/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import tigase.annotations.TigaseDeprecated;
import tigase.db.TigaseDBException;
import tigase.http.AuthProvider;
import tigase.http.java.AsyncContextImpl;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@TigaseDeprecated(removeIn="9.0.0", since="8.5.0", note="RequestHandler will be removed")
@Deprecated
public class DummyServletRequest
implements HttpServletRequest {
    private final String contextPath;
    private final HttpExchange exchange;
    private final Integer executionTimeout;
    private final Map<String, String[]> params;
    private final Cookie[] cookies;
    private final AuthProvider authProvider;
    private final String servletPath;
    private final ScheduledExecutorService timer;
    private AsyncContext async;
    private String characterEncoding = "UTF-8";
    private Principal principal;
    private BufferedReader reader;
    private int requestId;
    private HttpServletResponse response;
    private Map<String, Object> attributes = null;
    private String serverName;
    private Integer serverPort;
    private Boolean secure;

    public DummyServletRequest(int requestId, HttpExchange exchange, String contextPath, String servletPath, AuthProvider authProvider, ScheduledExecutorService timer, Integer executionTimeout, HttpServletResponse response) {
        this.requestId = requestId;
        this.exchange = exchange;
        this.params = new HashMap<String, String[]>();
        this.response = response;
        String query = exchange.getRequestURI().getRawQuery();
        if (query != null) {
            this.decodeParamsFromString(query, this.params);
        }
        if ("application/x-www-form-urlencoded".equals(this.getContentType())) {
            int len = this.getContentLength();
            byte[] data = new byte[len];
            try {
                exchange.getRequestBody().read(data);
                this.decodeParamsFromString(new String(data), this.params);
            }
            catch (IOException ex) {
                Logger.getLogger(DummyServletRequest.class.getName()).log(Level.FINE, "could not read parameters from input stream", ex);
            }
        }
        this.cookies = (Cookie[])exchange.getRequestHeaders().entrySet().stream().filter(entry -> "Cookie".equalsIgnoreCase((String)entry.getKey())).flatMap(entry1 -> ((List)entry1.getValue()).stream()).flatMap(item -> Arrays.stream(item.split(";"))).map(cookie -> {
            int idx = cookie.indexOf(61);
            if (idx < 0) {
                return null;
            }
            try {
                return new Cookie(cookie.substring(0, idx), idx < cookie.length() - 1 ? cookie.substring(idx + 1) : "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }).filter(Objects::nonNull).toArray(Cookie[]::new);
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.authProvider = authProvider;
        this.timer = timer;
        this.executionTimeout = executionTimeout;
    }

    public Object getAttribute(String string) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        this.characterEncoding = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContentLength() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            String contentLength;
            block4: {
                contentLength = this.exchange.getRequestHeaders().getFirst("Content-Length");
                if (contentLength != null && !contentLength.isEmpty()) break block4;
                return 0;
            }
            return Integer.parseInt(contentLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentType() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.exchange.getRequestHeaders().getFirst("Content-Type");
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){
            private boolean finished = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read() throws IOException {
                HttpExchange httpExchange = DummyServletRequest.this.exchange;
                synchronized (httpExchange) {
                    int read = DummyServletRequest.this.exchange.getRequestBody().read();
                    this.finished = read == -1;
                    return read;
                }
            }

            public boolean isFinished() {
                return this.finished;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isReady() {
                HttpExchange httpExchange = DummyServletRequest.this.exchange;
                synchronized (httpExchange) {
                    try {
                        return DummyServletRequest.this.exchange.getRequestBody().available() > 0;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            }

            public void setReadListener(ReadListener rl) {
                throw new UnsupportedOperationException("setReadListener is not supported!");
            }
        };
    }

    public String getParameter(String key) {
        String[] val = this.params.get(key);
        return val != null && val.length == 1 ? val[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        return new IteratorEnumerator(this.params.keySet().iterator());
    }

    public String[] getParameterValues(String key) {
        return this.params.get(key);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProtocol() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.exchange.getProtocol();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScheme() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.isSecure() ? "https" : "http";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerName() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            if (this.serverName == null) {
                this.prepareServerNameAndPort();
            }
            return this.serverName;
        }
    }

    private void prepareServerNameAndPort() {
        String host = this.exchange.getRequestHeaders().getFirst("X-Forwarded-Host");
        if (host == null || host.isEmpty()) {
            host = this.exchange.getRequestHeaders().getFirst("Host");
        }
        if (host != null && !host.endsWith("]")) {
            int idx = host.lastIndexOf(58);
            if (idx != -1) {
                this.serverName = host.substring(0, idx);
                this.serverPort = Integer.parseInt(host.substring(idx + 1));
            } else {
                this.serverName = host;
            }
        } else {
            this.serverName = host;
        }
        if (this.serverPort == null) {
            this.serverPort = this.isSecure() ? 443 : 80;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServerPort() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            if (this.serverPort == null) {
                this.prepareServerNameAndPort();
            }
            return this.serverPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedReader getReader() throws IOException {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader(this.exchange.getRequestBody(), this.characterEncoding));
            }
        }
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteAddr() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.exchange.getRemoteAddress().toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteHost() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.exchange.getRemoteAddress().getHostName();
        }
    }

    public void setAttribute(String string, Object o) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(string, o);
    }

    public void removeAttribute(String string) {
        if (this.attributes != null) {
            this.attributes.remove(string);
        }
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecure() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            if (this.secure == null) {
                String proto = this.exchange.getRequestHeaders().getFirst("X-Forwarded-Proto");
                this.secure = proto != null ? Boolean.valueOf("https".equalsIgnoreCase(proto) || "http2".equalsIgnoreCase(proto)) : Boolean.valueOf(this.exchange.getHttpContext().getServer() instanceof HttpsServer);
            }
            return this.secure;
        }
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return null;
    }

    public String getRealPath(String string) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemotePort() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.exchange.getRemoteAddress().getPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalName() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.exchange.getRequestURI().getHost();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalAddr() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.exchange.getLocalAddress().toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalPort() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.exchange.getLocalAddress().getPort();
        }
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.startAsync((ServletRequest)this, (ServletResponse)this.response);
    }

    public AsyncContext startAsync(ServletRequest sr, ServletResponse sr1) throws IllegalStateException {
        this.async = new AsyncContextImpl(sr, sr1, this.exchange, this.timer);
        this.async.setTimeout((long)(this.executionTimeout * 2));
        return this.async;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return this.async;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String string) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader(String string) {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.exchange.getRequestHeaders().getFirst(string);
        }
    }

    public Enumeration<String> getHeaders(String string) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getHeaderNames() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return Collections.enumeration(this.exchange.getRequestHeaders().keySet());
        }
    }

    public int getIntHeader(String string) {
        return 0;
    }

    public String getMethod() {
        return this.exchange.getRequestMethod();
    }

    public String getPathInfo() {
        int start = this.contextPath.length() + this.servletPath.length();
        if (this.servletPath.endsWith("/")) {
            --start;
        }
        return this.getRequestURI().substring(start);
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueryString() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            return this.exchange.getRequestURI().getQuery();
        }
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        Principal principal = this.getUserPrincipal();
        if ("user".equals(role)) {
            return principal != null;
        }
        try {
            if ("admin".equals(role)) {
                return principal != null && this.authProvider.isAdmin(BareJID.bareJIDInstance((String)principal.getName()));
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public Principal getUserPrincipal() {
        if (this.principal == null) {
            String authStr;
            AuthProvider.JWTPayload payload = this.authProvider.authenticateWithCookie(this);
            if (payload != null) {
                this.principal = () -> payload.subject().toString();
            }
            if (this.principal == null && (authStr = this.getHeader("Authorization")) != null && authStr.startsWith("Basic")) {
                authStr = authStr.replace("Basic ", "");
                authStr = new String(Base64.decode((String)authStr));
                int idx = authStr.indexOf(":");
                String user = authStr.substring(0, idx);
                String pass = authStr.substring(idx + 1);
                try {
                    if (this.authProvider.checkCredentials(user, pass)) {
                        String jid = user;
                        this.principal = () -> jid;
                    }
                }
                catch (TigaseDBException | TigaseStringprepException ex) {
                    Logger.getLogger(DummyServletRequest.class.getName()).log(Level.FINEST, "could not authorize user", ex);
                }
            }
        }
        return this.principal;
    }

    public String getRequestedSessionId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequestURI() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            String uri = this.exchange.getRequestURI().toString();
            int idx = uri.indexOf("?");
            if (idx > -1) {
                uri = uri.substring(0, idx);
            }
            return uri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer getRequestURL() {
        StringBuffer buf = new StringBuffer();
        try {
            HttpExchange httpExchange = this.exchange;
            synchronized (httpExchange) {
                if (this.exchange.getRequestURI().isAbsolute()) {
                    buf.append(this.exchange.getRequestURI().toURL().toExternalForm());
                } else {
                    boolean secure = this.isSecure();
                    if (secure) {
                        buf.append("https");
                    } else {
                        buf.append("http");
                    }
                    buf.append("://").append(this.getServerName());
                    int port = this.getServerPort();
                    if (this.isSecure() && port != 443 || !this.isSecure() && port != 80) {
                        buf.append(':').append(port);
                    }
                    buf.append(this.exchange.getRequestURI().getPath());
                }
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(DummyServletRequest.class.getName()).log(Level.FINE, "could not read request URL", ex);
        }
        return buf;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean bln) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(HttpServletResponse hsr) throws IOException, ServletException {
        hsr.setHeader("WWW-Authenticate", "Basic realm=\"TigasePlain\"");
        hsr.sendError(401, "Not authorized");
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            if (!"HEAD".equals(this.exchange.getRequestMethod())) {
                this.exchange.getResponseBody().flush();
                this.exchange.getResponseBody().close();
            }
        }
        return false;
    }

    public void login(String string, String string1) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String string) throws IOException, ServletException {
        return null;
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> type) throws IOException, ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLengthLong() {
        HttpExchange httpExchange = this.exchange;
        synchronized (httpExchange) {
            String contentLength;
            block4: {
                contentLength = this.exchange.getRequestHeaders().getFirst("Content-Length");
                if (contentLength != null && !contentLength.isEmpty()) break block4;
                return 0L;
            }
            return Long.parseLong(contentLength);
        }
    }

    public String toString() {
        return this.requestId + " for " + this.getRequestURI();
    }

    private void decodeParamsFromString(String query, Map<String, String[]> params) {
        String[] stringArray = query.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String[] val = part.split("=");
            try {
                String v;
                String k = URLDecoder.decode(val[0], "UTF-8");
                String string = v = val.length == 1 ? "" : URLDecoder.decode(val[1], "UTF-8");
                if (params.containsKey(k)) {
                    String[] oldV = params.get(k);
                    oldV = Arrays.copyOf(oldV, oldV.length + 1);
                    oldV[oldV.length - 1] = v;
                    params.put(k, oldV);
                } else {
                    params.put(k, new String[]{v});
                }
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(DummyServletRequest.class.getName()).log(Level.FINE, "could not decode URLEncoded paramters", ex);
            }
            ++n2;
        }
    }

    private class IteratorEnumerator<T, K extends Iterator<T>>
    implements Enumeration<T> {
        private final Iterator<T> iter;

        public IteratorEnumerator(Iterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iter.next();
        }
    }
}

