/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.wellknown;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.http.modules.AbstractBareModule;
import tigase.http.modules.wellknown.WellKnownModule;

public class HostMetaServlet
extends HttpServlet {
    public static final String MODULE_ID_KEY = "module-id-key";
    private WellKnownModule module;

    public void init() throws ServletException {
        super.init();
        ServletConfig cfg = super.getServletConfig();
        String moduleName = cfg.getInitParameter(MODULE_ID_KEY);
        this.module = (WellKnownModule)AbstractBareModule.getModuleByUUID(moduleName);
    }

    public String getServletInfo() {
        return "Short description";
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Format format = Optional.ofNullable(this.getInitParameter("format")).map(Format::valueOf).or(() -> Optional.ofNullable(request.getPathInfo()).map(path -> path.startsWith("/host-meta.json")).map(v -> v != false ? Format.json : Format.xml)).orElse(Format.xml);
        String domain = Optional.ofNullable(request.getHeader("domain")).orElse(Optional.of(request.getServerName()).map(str -> str.split(":")).map(arr -> arr[0]).get());
        try (PrintWriter out = null;){
            List<Link> links = this.module.getHostMetaLinks(domain);
            if (links == null) {
                response.sendError(404);
            } else {
                response.setHeader("Access-Control-Allow-Origin", "*");
                StringBuilder sb = new StringBuilder(1000);
                switch (format) {
                    case xml: {
                        response.setContentType("application/xml");
                        out = response.getWriter();
                        sb.append("<?xml version='1.0' encoding='utf-8'?>\n<XRD xmlns='http://docs.oasis-open.org/ns/xri/xrd-1.0'>");
                        sb.append(links.stream().map(Link::toXML).collect(Collectors.joining()));
                        sb.append("</XRD>");
                        break;
                    }
                    case json: {
                        response.setContentType("application/json");
                        out = response.getWriter();
                        String callback = request.getParameter("callback");
                        if (callback != null) {
                            sb.append(callback);
                            sb.append("(");
                        }
                        sb.append("{ \"links\": [");
                        sb.append(links.stream().map(Link::toJSON).collect(Collectors.joining(",")));
                        sb.append("]}");
                        if (callback == null) break;
                        sb.append(")");
                    }
                }
                out.append(sb.toString());
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public static class AbstractLink
    implements Link {
        final String type;
        final String url;

        AbstractLink(String type, String url) {
            this.type = type;
            this.url = url;
        }

        @Override
        public String getURL() {
            return this.url;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String toJSON() {
            return "{\"rel\": \"" + this.getType() + "\", \"href\": \"" + this.getURL() + "\"}";
        }

        @Override
        public String toXML() {
            return "<Link rel=\"" + this.getType() + "\" href=\"" + this.getURL() + "\" />";
        }
    }

    public static class BoshLink
    extends AbstractLink {
        public BoshLink(String url) {
            super("urn:xmpp:alt-connections:xbosh", url);
        }
    }

    static enum Format {
        json,
        xml;

    }

    static interface Link {
        public String getType();

        public String getURL();

        public String toJSON();

        public String toXML();
    }

    public static class WebSocketLink
    extends AbstractLink {
        public WebSocketLink(String url) {
            super("urn:xmpp:alt-connections:websocket", url);
        }
    }
}

