/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.http.AuthProvider;
import tigase.http.DeploymentInfo;
import tigase.http.HttpMessageReceiver;
import tigase.http.PacketWriter;
import tigase.http.ServletInfo;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.JaxRsModule;
import tigase.http.modules.AbstractModule;
import tigase.http.modules.rest.ApiKeyAddCmd;
import tigase.http.modules.rest.ApiKeyRemoveCmd;
import tigase.http.modules.rest.ApiKeyRepository;
import tigase.http.modules.rest.ApiKeyUpdateCmd;
import tigase.http.modules.rest.RestServlet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.script.CommandIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="rest", parent=HttpMessageReceiver.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class RestModule
extends AbstractModule
implements JaxRsModule {
    private static final Logger log = Logger.getLogger(RestModule.class.getCanonicalName());
    private static final String DEF_SCRIPTS_DIR_VAL = "scripts/rest";
    private static final String SCRIPTS_DIR_KEY = "rest-scripts-dir";
    private ScheduledExecutorService executorService;
    @Inject
    private ApiKeyRepository apiKeyRepository;
    @Inject
    private AuthProvider authProvider;
    @Inject(nullAllowed=true)
    private List<Handler> handlers;
    private DeploymentInfo httpDeployment;
    @ConfigField(desc="Scripts directory", alias="rest-scripts-dir")
    private String scriptsDir = "scripts/rest";
    private final CommandIfc[] commands = new CommandIfc[]{new ApiKeyAddCmd(this), new ApiKeyRemoveCmd(this), new ApiKeyUpdateCmd(this)};

    @Override
    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    @Override
    public String getDescription() {
        return "REST support - handles HTTP REST access using scripts";
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers == null ? new ArrayList<Handler>() : handlers;
    }

    public static File[] getGroovyFiles(File scriptsDirFile) {
        if (scriptsDirFile.exists()) {
            return scriptsDirFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return s.endsWith("groovy");
                }
            });
        }
        if (log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, "scripts directory {0} does not exist!", scriptsDirFile);
        }
        return new File[0];
    }

    public ApiKeyRepository getApiKeyRepository() {
        return this.apiKeyRepository;
    }

    public void setApiKeyRepository(ApiKeyRepository apiKeyRepository) {
        if (this.getComponentName() != null) {
            apiKeyRepository.setRepoUser(BareJID.bareJIDInstanceNS((String)this.getName(), (String)this.getComponentName()));
            apiKeyRepository.setRepo(this.getUserRepository());
        }
        this.apiKeyRepository = apiKeyRepository;
    }

    @Override
    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public Kernel getKernel() {
        return RestModule.getKernel(this.uuid);
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        super.start();
        this.httpDeployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setAuthProvider(this.authProvider).setDeploymentName("HTTP/REST API").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        try {
            File scriptsDirFile = new File(this.scriptsDir);
            ServletInfo servletInfo = this.httpServer.servlet("RestServlet", RestServlet.class);
            servletInfo.addInitParam("module-uuid", this.uuid).addInitParam("script-dir", scriptsDirFile.getCanonicalPath()).addMapping("/*");
            this.httpDeployment.addServlets(servletInfo);
        }
        catch (IOException ex) {
            log.log(Level.FINE, "Exception while scanning for scripts to load", ex);
        }
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        super.stop();
    }

    public boolean isRequestAllowed(String key, String domain, String path) {
        return this.apiKeyRepository.isAllowed(key, domain, path);
    }

    @Override
    public void init(JID jid, String componentName, PacketWriter writer) {
        super.init(jid, componentName, writer);
        this.setApiKeyRepository(this.apiKeyRepository);
    }

    @Override
    public void initialize() {
        super.initialize();
        Arrays.stream(this.commands).forEach(this.commandManager::registerCmd);
    }

    @Override
    public void beforeUnregister() {
        super.beforeUnregister();
        Arrays.stream(this.commands).forEach(this.commandManager::unregisterCmd);
    }
}

