/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import tigase.auth.PasswordResetterIfc;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.Model;
import tigase.http.modules.dashboard.DashboardHandler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.Token;
import tigase.xmpp.impl.CaptchaProvider;
import tigase.xmpp.jid.BareJID;

@Bean(name="resetPassword", parent=DashboardModule.class, active=true)
@Path(value="/users/resetPassword")
public class UserPasswordRecovery
extends DashboardHandler {
    private static final Logger log = Logger.getLogger(UserPasswordRecovery.class.getName());
    @ConfigField(desc="Require captcha")
    private boolean captchaRequired = true;
    @Inject
    private UserRepository userRepository;
    @Inject(nullAllowed=true)
    private PasswordResetterIfc[] resetters;

    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.None;
    }

    public boolean isPasswordResetEnabled() {
        return this.resetters != null && this.resetters.length > 0;
    }

    @GET
    @Path(value="")
    public Response form(Model model) {
        if (this.captchaRequired) {
            CaptchaProvider.SimpleTextCaptcha captcha = this.generateCaptcha();
            model.put("captcha", captcha.getCaptchaRequest());
            model.put("captchaID", captcha.getID());
        }
        model.put("enabled", this.isPasswordResetEnabled());
        if (!this.isPasswordResetEnabled()) {
            model.put("errors", List.of("Password resetting is disabled!"));
        }
        String output = this.renderTemplate("users/resetPasswordForm.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }

    @POST
    @Path(value="")
    public Response executeForm(@FormParam(value="jid") @NotEmpty BareJID jid, @FormParam(value="email") @Email String email, @FormParam(value="captcha") String captchaResponse, @FormParam(value="captchaID") String captchaID, UriInfo uriInfo, Model model) throws Exception {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.captchaRequired && !this.validateCaptcha(captchaID, captchaResponse)) {
            errors.add("Provided captcha result is invalid!");
        }
        if (errors.isEmpty()) {
            try {
                String storedEmail = this.userRepository.getData(jid, "email");
                if (storedEmail == null || !storedEmail.equalsIgnoreCase(email)) {
                    errors.add("Provided email address does not match email address used during registration. Please try different one or contact XMPP server administrator.");
                }
            }
            catch (UserNotFoundException userNotFoundException) {
                errors.add("Provided email address does not match email address used during registration. Please try different one or contact XMPP server administrator.");
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Database issue when processing request for user " + String.valueOf(jid), ex);
                errors.add("Internal error occurred. Please try again later.");
            }
        }
        if (!errors.isEmpty()) {
            model.put("errors", errors);
            return this.form(model);
        }
        String resetUrl = uriInfo.getBaseUriBuilder().path(UserPasswordRecovery.class).build(new Object[0]).toString();
        if (this.resetters != null) {
            PasswordResetterIfc[] passwordResetterIfcArray = this.resetters;
            int n = this.resetters.length;
            int n2 = 0;
            while (n2 < n) {
                PasswordResetterIfc resetter = passwordResetterIfcArray[n2];
                resetter.sendToken(jid, (String)(resetUrl.endsWith("/") ? resetUrl : resetUrl + "/"));
                ++n2;
            }
        }
        String output = this.renderTemplate("users/resetPasswordForm.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }

    @GET
    @Path(value="/{token}")
    public Response resetPassword(@PathParam(value="token") @NotEmpty String token, Model model) {
        if (!this.isPasswordResetEnabled()) {
            model.put("errors", List.of("Password resetting is disabled!"));
            model.put("enabled", this.isPasswordResetEnabled());
            return this.form(model);
        }
        PasswordResetterIfc resetter = Arrays.stream(this.resetters).filter(it -> {
            try {
                it.validateToken(token);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }).findFirst().orElse(null);
        if (resetter == null) {
            model.put("errors", List.of("Invalid token!"));
            return this.form(model);
        }
        try {
            Token.parse((String)token).getJid();
            String output = this.renderTemplate("users/resetPasswordTokenForm.jte", model);
            return Response.ok((Object)output, (String)"text/html").build();
        }
        catch (RuntimeException e) {
            model.put("errors", List.of(e.getMessage()));
            return this.form(model);
        }
    }

    @POST
    @Path(value="/{token}")
    public Response resetPassword(@PathParam(value="token") @NotEmpty String token, @FormParam(value="password-entry") @NotEmpty String passwordEntry, @FormParam(value="password-reentry") @NotEmpty String passwordReentry, Model model) {
        BareJID jid = Token.parse((String)token).getJid();
        PasswordResetterIfc resetter = Arrays.stream(this.resetters).filter(it -> {
            try {
                it.validateToken(token);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }).findFirst().orElse(null);
        if (resetter == null) {
            model.put("errors", List.of("Invalid token!"));
            return this.form(model);
        }
        if (Objects.equals(passwordEntry, passwordReentry)) {
            try {
                resetter.changePassword(token, passwordEntry);
            }
            catch (Exception exception) {
                model.put("errors", List.of("Internal error occurred. Please try again later."));
                return this.form(model);
            }
        }
        model.put("jid", jid);
        String output = this.renderTemplate("users/resetPasswordToken.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }
}

