/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.Model;
import tigase.http.modules.dashboard.DashboardHandler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.kernel.beans.Bean;
import tigase.server.XMPPServer;
import tigase.sys.TigaseRuntime;

@Bean(name="serverInfo", parent=DashboardModule.class, active=true)
@Path(value="/server/info")
public class ServerInfoHandler
extends DashboardHandler {
    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.Admin;
    }

    @GET
    @Path(value="")
    @Produces(value={"text/html"})
    @RolesAllowed(value={"admin"})
    public Response info(Model model) {
        model.put("dataJson", this.prepareJSON());
        String output = this.renderTemplate("server/info.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }

    @GET
    @Path(value="")
    @RolesAllowed(value={"admin"})
    @Produces(value={"application/json"})
    public Response infoJson() {
        return Response.ok((Object)this.prepareJSON(), (String)"application/json").build();
    }

    private static StringBuilder append(StringBuilder sb, String name, String value) {
        sb.append("\"").append(name).append("\": ");
        sb.append("\"").append(value).append("\"");
        return sb;
    }

    private static StringBuilder append(StringBuilder sb, String name, int value) {
        sb.append("\"").append(name).append("\": ");
        sb.append(value);
        return sb;
    }

    private static StringBuilder append(StringBuilder sb, String name, double value) {
        sb.append("\"").append(name).append("\": ");
        sb.append(String.format(Locale.ROOT, "%.2f", value));
        return sb;
    }

    private String prepareJSON() {
        TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        ServerInfoHandler.append(sb, "data-uptime", runtime.getUptimeString()).append(",");
        ServerInfoHandler.append(sb, "data-load-average", runtime.getLoadAverage()).append(",");
        ServerInfoHandler.append(sb, "data-cpus-no", runtime.getCPUsNumber()).append(",");
        ServerInfoHandler.append(sb, "data-threads-count", runtime.getThreadsNumber()).append(",");
        ServerInfoHandler.append(sb, "data-cpu-usage-proc", runtime.getCPUUsage()).append(",");
        ServerInfoHandler.append(sb, "data-heap-usage-proc", runtime.getHeapMemUsage()).append(",");
        ServerInfoHandler.append(sb, "data-nonheap-usage-proc", runtime.getNonHeapMemUsage()).append(",");
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ServerInfoHandler.append(sb, "version", XMPPServer.getImplementationVersion()).append(",");
        ServerInfoHandler.append(sb, "report-creation-timstamp", dtf.format(new Date()));
        sb.append("}");
        return sb.toString();
    }
}

