/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs.marshallers;

import jakarta.xml.bind.MarshalException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import tigase.http.jaxrs.marshallers.AbstractMarshaller;
import tigase.http.jaxrs.marshallers.Marshaller;
import tigase.http.json.JsonSerializer;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class JsonMarshaller
extends AbstractMarshaller
implements Marshaller {
    private static final Map<Class, Function<Object, Object>> DEFAULT_SERIALIZERS = new HashMap<Class, Function<Object, Object>>();
    private final Map<Class, Function<Object, Object>> SERIALIZERS = new HashMap<Class, Function<Object, Object>>(DEFAULT_SERIALIZERS);

    static {
        List.of(Long.class, Double.class, Integer.class, Float.class, UUID.class, LocalTime.class).forEach(clazz -> {
            Function<Object, Object> function = DEFAULT_SERIALIZERS.put((Class)clazz, obj -> obj.toString());
        });
        List.of(ZonedDateTime.class).forEach(clazz -> {
            Function<Object, Object> function = DEFAULT_SERIALIZERS.put((Class)clazz, obj -> ((ZonedDateTime)obj).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        });
        List.of(LocalDateTime.class, LocalDate.class).forEach(clazz -> {
            Function<Object, Object> function = DEFAULT_SERIALIZERS.put((Class)clazz, obj -> obj.toString());
        });
        DEFAULT_SERIALIZERS.put(Date.class, obj -> ZonedDateTime.ofInstant(((Date)obj).toInstant(), ZoneId.systemDefault()));
        DEFAULT_SERIALIZERS.put(JID.class, obj -> obj.toString());
        DEFAULT_SERIALIZERS.put(BareJID.class, obj -> obj.toString());
    }

    @Override
    public void marshall(Object object, OutputStream outputStream) throws MarshalException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            this.marshall(object, writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void marshall(Object object, Writer writer) throws IOException, MarshalException {
        writer.write("{");
        Class<?> clazz = object.getClass();
        try {
            boolean first = true;
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Object value = this.getFieldValue(object, field);
                if (value != null) {
                    if (!first) {
                        writer.write(",");
                    } else {
                        first = false;
                    }
                    writer.write(JsonSerializer.escapeString(field.getName()));
                    writer.write(":");
                    this.serializeValue(value, writer);
                }
                ++n2;
            }
            writer.write("}");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MarshalException("Could not marshal instance of " + clazz.getName(), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void serializeValue(Object value, Writer writer) throws IOException, MarshalException {
        block7: {
            block8: {
                block6: {
                    if (!(value instanceof Collection)) break block6;
                    writer.write("[");
                    first = true;
                    for (E item : (Collection)value) {
                        if (!first) {
                            writer.write(",");
                        } else {
                            first = false;
                        }
                        this.serializeValue(item, writer);
                    }
                    writer.write("]");
                    break block7;
                }
                if (!(value instanceof Boolean) && !(value instanceof Long) && !(value instanceof Integer) && !(value instanceof Double) && !(value instanceof Float)) break block8;
                writer.write(value.toString());
                break block7;
            }
            if (!(value instanceof Enum)) ** GOTO lbl22
            writer.write(JsonSerializer.escapeString(((Enum)value).name()));
            break block7;
lbl-1000:
            // 1 sources

            {
                value = mapper.apply(value);
lbl22:
                // 2 sources

                ** while ((mapper = this.SERIALIZERS.get(value.getClass())) != null)
            }
lbl23:
            // 1 sources

            if (value instanceof String) {
                writer.write(JsonSerializer.escapeString(value.toString()));
            } else {
                this.marshall(value, writer);
            }
        }
    }
}

