/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.stats;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import tigase.http.HttpMessageReceiver;
import tigase.http.stats.HttpStatsCollector;
import tigase.kernel.beans.Bean;
import tigase.stats.StatisticsList;

@Bean(name="host-name-stats-collector", parent=HttpMessageReceiver.class, active=false)
public class HostNameStatsCollector
implements HttpStatsCollector {
    private static final String key = "host-count/";
    private final Map<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();

    @Override
    public void getStatistics(String name, StatisticsList list) {
        this.counters.forEach((host, count) -> list.add(name, key + host, count.get(), Level.FINEST));
    }

    @Override
    public void count(HttpServletRequest request) {
        String host = request.getHeader("Host");
        host = host.contains(":") ? host.substring(0, host.indexOf(58)) : host;
        this.counters.computeIfAbsent(host, k -> new AtomicLong()).getAndIncrement();
    }

    public String toString() {
        return this.counters.toString();
    }
}

