/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.http.AuthProvider;
import tigase.http.DeploymentInfo;
import tigase.http.HttpMessageReceiver;
import tigase.http.ServletInfo;
import tigase.http.jaxrs.AbstractJaxRsModule;
import tigase.http.modules.setup.Config;
import tigase.http.modules.setup.InitialPage;
import tigase.http.modules.setup.NextPage;
import tigase.http.modules.setup.SetupHandler;
import tigase.http.modules.setup.SetupServlet;
import tigase.http.util.AssetsServlet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Bean(name="setup", parent=HttpMessageReceiver.class, active=true)
public class SetupModule
extends AbstractJaxRsModule<SetupHandler> {
    private static final Logger log = Logger.getLogger(SetupModule.class.getCanonicalName());
    @ConfigField(desc="Allow access to setup with password", alias="admin-password")
    private String adminPassword = null;
    @ConfigField(desc="Allow access to setup for user", alias="admin-user")
    private String adminUser = null;
    private Config config = new Config();
    private ScheduledExecutorService executorService;
    @Inject(nullAllowed=true)
    private List<SetupHandler> handlersAll;
    private List<SetupHandler> handlers = new ArrayList<SetupHandler>();
    @Inject(nullAllowed=true)
    private AuthRepository authRepository;
    private DeploymentInfo httpDeployment;

    public Config getConfig() {
        return this.config;
    }

    @Override
    public String getDescription() {
        return "Setup";
    }

    public void setHandlersAll(List<SetupHandler> handlers) {
        this.handlersAll = handlers == null ? new ArrayList<SetupHandler>() : handlers;
        Optional<SetupHandler> handlerOptional = this.handlersAll.stream().filter(h -> h.getClass().getAnnotation(InitialPage.class) != null).findFirst();
        if (handlerOptional.isPresent()) {
            NextPage nextPage;
            ArrayList<SetupHandler> value = new ArrayList<SetupHandler>();
            SetupHandler handler = handlerOptional.get();
            value.add(handler);
            while ((nextPage = handler.getClass().getAnnotation(NextPage.class)) != null) {
                handler = null;
                for (SetupHandler it : handlers) {
                    if (!nextPage.value().isInstance(it)) continue;
                    handler = it;
                }
                if (handler == null) break;
                value.add(handler);
            }
            this.handlers = value;
        } else {
            this.handlers = Collections.EMPTY_LIST;
        }
    }

    @Override
    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public List<SetupHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        super.start();
        this.httpDeployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setAuthProvider(new AuthProvider(){

            @Override
            public boolean isAdmin(BareJID user) {
                return Optional.ofNullable(user).map(BareJID::toString).filter(userStr -> Objects.equals(userStr, SetupModule.this.adminUser)).isPresent() || SetupModule.this.getAuthProvider().isAdmin(user);
            }

            @Override
            public boolean checkCredentials(String user, String password) throws TigaseStringprepException, TigaseDBException {
                if (Objects.equals(user, SetupModule.this.adminUser) && Objects.equals(password, SetupModule.this.adminPassword)) {
                    return true;
                }
                return SetupModule.this.getAuthProvider().checkCredentials(user, password);
            }

            @Override
            public String generateToken(AuthProvider.JWTPayload token) throws NoSuchAlgorithmException, InvalidKeyException {
                throw new RuntimeException("Feature not implemented!");
            }

            @Override
            public AuthProvider.JWTPayload parseToken(String token) throws AuthenticationException {
                throw new RuntimeException("Feature not implemented!");
            }

            @Override
            public AuthProvider.JWTPayload authenticateWithCookie(HttpServletRequest request) {
                return null;
            }

            @Override
            public Duration getAuthenticationTokenValidityDuration() {
                return Duration.ofMinutes(15L);
            }

            @Override
            public void setAuthenticationCookie(HttpServletResponse response, AuthProvider.JWTPayload payload, String domain, String path) throws NoSuchAlgorithmException, InvalidKeyException {
                throw new RuntimeException("Feature not implemented!");
            }

            @Override
            public void resetAuthenticationCookie(HttpServletResponse response, String domain, String path) {
                throw new RuntimeException("Feature not implemented!");
            }

            @Override
            public void refreshJwtToken(HttpServletRequest request, HttpServletResponse response) {
            }
        }).setDeploymentName("Setup").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        ServletInfo servletInfo = this.httpServer.servlet("SetupServlet", SetupServlet.class);
        servletInfo.addInitParam("module-uuid", this.uuid).addMapping("/*");
        this.httpDeployment.addServlets(servletInfo);
        servletInfo = this.httpServer.servlet("AssetsServlet", AssetsServlet.class);
        servletInfo.addMapping("/assets/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        super.stop();
    }
}

