/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import tigase.auth.credentials.entries.XTokenCredentialsEntry;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.db.services.AccountExpirationService;
import tigase.eventbus.EventBus;
import tigase.http.api.HttpException;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.Model;
import tigase.http.jaxrs.Page;
import tigase.http.jaxrs.Pageable;
import tigase.http.jaxrs.SecurityContextHolder;
import tigase.http.jaxrs.annotations.JidLocalpart;
import tigase.http.modules.dashboard.DashboardHandler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.http.modules.dashboard.PermissionsHelper;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.xmppsession.DisconnectUserEBAction;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.StreamError;
import tigase.xmpp.jid.BareJID;

@Bean(name="users", parent=DashboardModule.class, active=true)
@Path(value="/users")
public class UsersHandler
extends DashboardHandler {
    private final SecureRandom secureRandom = new SecureRandom();
    @Inject
    private AuthRepository authRepository;
    @Inject
    private UserRepository userRepository;
    @Inject
    private PermissionsHelper permissionsHelper;
    @Inject
    private EventBus eventBus;
    @Inject(nullAllowed=true)
    private DashboardModule dashboardModule;
    @Inject(nullAllowed=true)
    private AccountExpirationService accountExpirationService;
    System.Logger logger = System.getLogger(UsersHandler.class.getName());

    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.User;
    }

    @GET
    @Path(value="")
    @Produces(value={"text/html"})
    @RolesAllowed(value={"admin", "account_manager", "user"})
    public Response index(@QueryParam(value="query") String query, SecurityContext securityContext, Pageable pageable, Model model) throws TigaseDBException {
        List<String> domains = this.permissionsHelper.getManagedDomains(securityContext);
        HashSet<String> domainsSet = new HashSet<String>(domains);
        List<BareJID> jids = this.getManagedUsers(securityContext, domainsSet).filter(jid -> query == null || jid.toString().contains(query)).sorted(Comparator.comparing(BareJID::getLocalpart).thenComparing(BareJID::getDomain)).toList();
        List<User> users = jids.stream().skip(pageable.offset()).limit(pageable.pageSize()).map(jid -> {
            try {
                return new User((BareJID)jid, this.authRepository.getAccountStatus(jid), this.getUserRoles((BareJID)jid), this.canManageUser((BareJID)jid));
            }
            catch (TigaseDBException e) {
                throw new RuntimeException(e);
            }
        }).toList();
        model.put("query", query);
        model.put("users", new Page<User>(pageable, jids.size(), users));
        model.put("domains", domains);
        model.put("allRoles", this.getAllRoles());
        model.put("accountExpirationService", this.accountExpirationService);
        model.put("isXTokenActive", this.authRepository.isMechanismSupported("default", "XTOKEN-HMAC-SHA-256"));
        String output = this.renderTemplate("users/index.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }

    private Stream<BareJID> getManagedUsers(SecurityContext securityContext, Set<String> domains) throws TigaseDBException {
        BareJID userJid;
        Stream<BareJID> users = this.userRepository.getUsers().stream().filter(jid -> jid.getLocalpart() != null).filter(jid -> domains.contains(jid.getDomain()));
        if (securityContext.isUserInRole("user") && this.userRepository.userExists(userJid = BareJID.bareJIDInstanceNS((String)securityContext.getUserPrincipal().getName()))) {
            users = Stream.concat(users, Stream.of(userJid)).distinct();
        }
        return users;
    }

    private List<UserRole> getAllRoles() {
        return this.mapRoleIdsToUserRoles(List.of("account_manager"));
    }

    private List<UserRole> getUserRoles(BareJID jid) throws TigaseDBException {
        return this.mapRoleIdsToUserRoles(this.getUserRolesIds(jid));
    }

    private List<UserRole> mapRoleIdsToUserRoles(List<String> roleIds) {
        return roleIds.stream().map(it -> new UserRole((String)it, switch (it) {
            case "admin" -> "Administrator";
            case "account_manager" -> "Account Manager";
            case "user" -> "User";
            default -> Arrays.stream(it.split("_")).map(str -> str.substring(0, 1).toUpperCase() + str.substring(1)).collect(Collectors.joining(" "));
        })).sorted().toList();
    }

    private List<String> getUserRolesIds(BareJID user) throws TigaseDBException {
        String[] rolesFromRepo;
        ArrayList<String> roles = new ArrayList<String>();
        if (this.dashboardModule.isAdmin(user)) {
            roles.add("admin");
        }
        if ((rolesFromRepo = this.userRepository.getDataList(user, "roles", "roles")) != null) {
            roles.addAll(Arrays.asList(rolesFromRepo));
        }
        return roles;
    }

    private boolean canManageUser(BareJID jid) {
        block5: {
            SecurityContext securityContext;
            block6: {
                try {
                    securityContext = SecurityContextHolder.getSecurityContext();
                    if (securityContext == null) break block5;
                    if (!securityContext.isUserInRole("admin")) break block6;
                    return true;
                }
                catch (TigaseDBException tigaseDBException) {}
            }
            if (securityContext.isUserInRole("account_manager")) {
                List<String> managedUserRoles = this.getUserRolesIds(jid);
                return !managedUserRoles.contains("admin") && !managedUserRoles.contains("account_manager") || securityContext.getUserPrincipal().getName().equals(jid.toString());
            }
            if (securityContext.isUserInRole("user")) {
                return this.permissionsHelper.canManageDomain(securityContext, jid.getDomain()) || securityContext.getUserPrincipal().getName().equals(jid.toString());
            }
        }
        return false;
    }

    private void checkModificationPermission(BareJID jid) {
        if (!this.canManageUser(jid)) {
            throw new HttpException("Forbidden", 403);
        }
    }

    private void checkModificationPermission(String domain) {
        if (!this.permissionsHelper.canManageDomain(SecurityContextHolder.getSecurityContext(), domain)) {
            throw new HttpException("Forbidden", 403);
        }
    }

    @POST
    @Path(value="/create")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"admin", "account_manager", "user"})
    public Response createUser(@FormParam(value="localpart") @JidLocalpart(message="is not a valid username") @NotEmpty String localpart, @FormParam(value="domain") @NotEmpty String domain, @FormParam(value="password") String password, @FormParam(value="expiration") String expiration, UriInfo uriInfo) throws TigaseStringprepException, TigaseDBException {
        if (localpart.isBlank() || domain.isBlank()) {
            throw new RuntimeException();
        }
        this.checkModificationPermission(domain);
        BareJID jid = BareJID.bareJIDInstance((String)localpart.toLowerCase(), (String)domain);
        if (this.userRepository.userExists(jid)) {
            throw new RuntimeException("User already exist!");
        }
        if (password != null && !password.trim().isBlank()) {
            this.authRepository.addUser(jid, password);
            this.authRepository.setAccountStatus(jid, AuthRepository.AccountStatus.active);
            try {
                this.userRepository.addUser(jid);
            }
            catch (UserExistsException userExistsException) {}
        } else {
            this.userRepository.addUser(jid);
        }
        this.validateAndSetExpirationTime(jid, expiration);
        return UsersHandler.redirectToIndex(uriInfo, jid.toString());
    }

    @POST
    @Path(value="/{jid}/delete")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"admin", "account_manager", "user"})
    public Response deleteUser(@PathParam(value="jid") @NotEmpty BareJID jid, UriInfo uriInfo) throws TigaseDBException {
        this.checkModificationPermission(jid);
        this.authRepository.removeUser(jid);
        this.eventBus.fire((Object)new DisconnectUserEBAction(jid, StreamError.Reset, "Account was deleted"));
        return UsersHandler.redirectToIndex(uriInfo);
    }

    @GET
    @Path(value="/{jid}/accountStatus/{accountStatus}")
    @RolesAllowed(value={"admin", "account_manager", "user"})
    public Response changeAccountStatus(@PathParam(value="jid") @NotEmpty BareJID jid, @PathParam(value="accountStatus") AuthRepository.AccountStatus accountStatus, UriInfo uriInfo) throws TigaseDBException {
        this.checkModificationPermission(jid);
        this.authRepository.setAccountStatus(jid, accountStatus);
        switch (accountStatus) {
            case disabled: 
            case banned: 
            case spam: {
                this.logoutUser(jid);
                break;
            }
        }
        return UsersHandler.redirectToIndex(uriInfo);
    }

    @POST
    @Path(value="/{jid}/password")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"admin", "account_manager", "user"})
    public Response changePassword(@PathParam(value="jid") @NotEmpty BareJID jid, @FormParam(value="password") @NotBlank String password, @FormParam(value="password-confirm") @NotBlank String passwordConfirm, UriInfo uriInfo) throws TigaseDBException {
        this.checkModificationPermission(jid);
        if (!password.equals(passwordConfirm)) {
            throw new RuntimeException("Passwords do not match!");
        }
        this.authRepository.updateCredential(jid, "default", password);
        this.authRepository.setAccountStatus(jid, AuthRepository.AccountStatus.active);
        this.logoutUser(jid);
        return UsersHandler.redirectToIndex(uriInfo);
    }

    @POST
    @Path(value="/{jid}/roles")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"admin"})
    public Response updateRoles(@PathParam(value="jid") @NotEmpty BareJID jid, @FormParam(value="roles") List<String> newRoles, UriInfo uriInfo) throws TigaseDBException {
        this.userRepository.setDataList(jid, "roles", "roles", Optional.ofNullable(newRoles).map(list -> (String[])list.toArray(String[]::new)).orElse(new String[0]));
        return UsersHandler.redirectToIndex(uriInfo);
    }

    public static Response redirectToIndex(UriInfo uriInfo) {
        return UsersHandler.redirectToIndex(uriInfo, null);
    }

    public static Response redirectToIndex(UriInfo uriInfo, String query) {
        return Response.seeOther((URI)uriInfo.getBaseUriBuilder().path(UsersHandler.class, "index").replaceQueryParam("query", new Object[]{query}).build(new Object[0])).build();
    }

    @POST
    @Path(value="/{jid}/qrCode")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"image/png"})
    @RolesAllowed(value={"admin", "account_manager"})
    public Response generateAuthQrCodePng(@PathParam(value="jid") @NotEmpty BareJID jid) throws IOException, WriterException, TigaseDBException {
        this.checkModificationPermission(jid);
        String token = this.generateAuthQrCodeToken(jid);
        return Response.ok((Object)this.encodeStringToQRCode(token), (String)"image/png").build();
    }

    @POST
    @Path(value="/{jid}/qrCode")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin", "account_manager"})
    public QRCode generateAuthQrCodeJson(@PathParam(value="jid") @NotEmpty BareJID jid) throws IOException, WriterException, TigaseDBException {
        this.checkModificationPermission(jid);
        String token = this.generateAuthQrCodeToken(jid);
        byte[] qrcode = this.encodeStringToQRCode(token);
        return new QRCode(token, "data:image/png;base64," + Base64.encode((byte[])qrcode));
    }

    @POST
    @Path(value="/{jid}/expiration")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"admin", "account_manager"})
    public Response setAccountExpiration(@PathParam(value="jid") @NotEmpty BareJID jid, @FormParam(value="expiration") String expiration, UriInfo uriInfo) throws TigaseDBException {
        this.checkModificationPermission(jid);
        this.validateAndSetExpirationTime(jid, expiration);
        return UsersHandler.redirectToIndex(uriInfo);
    }

    private byte[] encodeStringToQRCode(String token) throws IOException, WriterException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(token.toString(), BarcodeFormat.QR_CODE, 300, 300, Map.of(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8, EncodeHintType.MARGIN, 0));
        MatrixToImageConfig imageConfig = new MatrixToImageConfig(-16777216, -1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)baos, (MatrixToImageConfig)imageConfig);
        return baos.toByteArray();
    }

    private String generateAuthQrCodeToken(BareJID jid) throws TigaseDBException {
        byte[] secret = new byte[32];
        this.secureRandom.nextBytes(secret);
        byte[] jidBytes = jid.toString().getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[secret.length + 1 + jidBytes.length];
        System.arraycopy(secret, 0, data, 0, secret.length);
        System.arraycopy(jidBytes, 0, data, secret.length + 1, jidBytes.length);
        String token = Base64.encode((byte[])data);
        this.authRepository.removeCredential(jid, "default");
        this.authRepository.updateCredential(jid, "default", "XTOKEN-HMAC-SHA-256", new XTokenCredentialsEntry(secret, true).encoded());
        this.authRepository.setAccountStatus(jid, AuthRepository.AccountStatus.active);
        this.logoutUser(jid);
        return token;
    }

    private void logoutUser(BareJID jid) throws TigaseDBException {
        this.eventBus.fire((Object)new DisconnectUserEBAction(jid, StreamError.Reset, "Account credentials were changed, please login again with new credentials"));
        this.authRepository.logout(jid);
    }

    private void validateAndSetExpirationTime(BareJID jid, String expiration) throws TigaseDBException {
        if (expiration == null || expiration.trim().isBlank()) {
            if (this.accountExpirationService != null) {
                this.accountExpirationService.setUserExpiration(jid, Integer.valueOf(0));
            }
        } else {
            try {
                Integer expirationTime = Integer.valueOf(expiration);
                this.accountExpirationService.setUserExpiration(jid, expirationTime);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.log(System.Logger.Level.WARNING, "Invalid expiration time: " + expiration + " for account " + String.valueOf(jid));
            }
        }
    }

    public static class QRCode {
        private final String token;
        private final String png;

        public QRCode(String token, String png) {
            this.token = token;
            this.png = png;
        }

        public String getToken() {
            return this.token;
        }

        public String getPng() {
            return this.png;
        }
    }

    public record User(BareJID jid, AuthRepository.AccountStatus accountStatus, List<UserRole> roles, boolean canManageUser) {
        public boolean hasRole(UserRole role) {
            return this.roles.stream().anyMatch(it -> it.id.equals(userRole.id));
        }
    }

    public record UserRole(String id, String label) {
    }
}

