/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.Model;
import tigase.http.jaxrs.annotations.JidLocalpart;
import tigase.http.modules.dashboard.DashboardHandler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.server.xmppsession.SessionManager;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostManager;
import tigase.xmpp.XMPPProcessorException;
import tigase.xmpp.impl.CaptchaProvider;
import tigase.xmpp.impl.JabberIqRegister;
import tigase.xmpp.jid.BareJID;

@Bean(name="register", parent=DashboardModule.class, active=true)
@Path(value="/users/register")
public class UserRegisterHandler
extends DashboardHandler {
    @Inject
    private AuthRepository authRepository;
    @Inject
    private UserRepository userRepository;
    @Inject
    private VHostManager vHostManager;
    @Inject
    private SessionManager sessionManager;

    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.None;
    }

    @GET
    @Path(value="")
    @Produces(value={"text/html"})
    public Response form(UriInfo uriInfo, Model model) {
        JabberIqRegister register = this.getJabberIqRegister();
        if (register == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List domains = this.vHostManager.getAllVHosts(false).stream().map(domain -> this.vHostManager.getVHostItem(domain.getDomain())).filter(vhost -> vhost.isEnabled() && vhost.isRegisterEnabled()).map(vhost -> vhost.getVhost().getDomain()).sorted().collect(Collectors.toList());
        int indexOfDomain = domains.indexOf(uriInfo.getBaseUri().getHost());
        if (indexOfDomain != -1) {
            String domain2 = (String)domains.remove(indexOfDomain);
            domains.addFirst(domain2);
        }
        model.put("domains", domains);
        model.put("emailRequired", register.isEmailRequired());
        if (register.isCaptchaRequired()) {
            CaptchaProvider.SimpleTextCaptcha captcha = this.generateCaptcha();
            model.put("captcha", captcha.getCaptchaRequest());
            model.put("captchaID", captcha.getID());
        }
        String output = this.renderTemplate("users/register.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }

    @POST
    @Path(value="")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public Response register(@FormParam(value="domain") @NotEmpty String domain, @FormParam(value="username") @JidLocalpart(message="is not a valid username") String username, @FormParam(value="password") @NotEmpty String password, @FormParam(value="email") @Email String email, @FormParam(value="captcha") String captchaResponse, @FormParam(value="captchaID") String captchaID, Model model) throws TigaseStringprepException, TigaseDBException {
        long domainUsers;
        JabberIqRegister register = this.getJabberIqRegister();
        if (register.isEmailRequired() && (email == null || email.isEmpty())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (register.isCaptchaRequired() && !this.validateCaptcha(captchaID, captchaResponse)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        VHostItem vhost = this.vHostManager.getVHostItem(domain);
        if (!vhost.isRegisterEnabled()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (vhost.getMaxUsersNumber() > 0L && (domainUsers = this.authRepository.getUsersCount(domain)) >= vhost.getMaxUsersNumber()) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        BareJID user = BareJID.bareJIDInstance((String)username, (String)domain);
        try {
            register.createAccount(this.authRepository, user, password, email, null);
        }
        catch (XMPPProcessorException xMPPProcessorException) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        model.put("jid", user);
        model.put("confirmationRequired", this.authRepository.getAccountStatus(user) == AuthRepository.AccountStatus.pending);
        String output = this.renderTemplate("users/registered.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }

    public boolean isRegistrationEnabled() {
        return this.getJabberIqRegister() != null;
    }

    private JabberIqRegister getJabberIqRegister() {
        Kernel kernel;
        block3: {
            try {
                Field f = SessionManager.class.getDeclaredField("kernel");
                f.setAccessible(true);
                kernel = (Kernel)f.get(this.sessionManager);
                if (kernel != null) break block3;
                return null;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        return (JabberIqRegister)kernel.getInstanceIfExistsOr("jabber:iq:register", x -> null);
    }
}

