/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.db.comp.RepositoryItem;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusEvent;
import tigase.eventbus.HandleEvent;
import tigase.http.api.HttpException;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.Model;
import tigase.http.jaxrs.Page;
import tigase.http.jaxrs.Pageable;
import tigase.http.jaxrs.SecurityContextHolder;
import tigase.http.modules.dashboard.DashboardHandler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.http.modules.dashboard.PermissionsHelper;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostManager;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.JID;

@Bean(name="domains", parent=DashboardModule.class, active=true)
@Path(value="/domains")
public class DomainsHandler
extends DashboardHandler
implements Initializable,
UnregisterAware {
    @Inject
    private PermissionsHelper permissionsHelper;
    @Inject
    private UserRepository userRepository;
    @Inject
    private VHostManager vHostManager;
    @Inject
    private EventBus eventBus;

    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.User;
    }

    @GET
    @Path(value="")
    @RolesAllowed(value={"admin", "user"})
    public Response index(@QueryParam(value="query") String query, SecurityContext securityContext, Pageable pageable, Model model) {
        List<DomainItem> domains = this.permissionsHelper.getManagedDomains(securityContext).stream().filter(domain -> query == null || domain.contains(query)).skip(pageable.offset()).limit(pageable.pageSize()).map(domain -> {
            long noOfUsers = this.userRepository.getUsersCount(domain);
            VHostItem item = this.vHostManager.getVHostItem(domain);
            return new DomainItem((String)domain, item, noOfUsers);
        }).sorted(Comparator.comparing(DomainItem::domain)).toList();
        model.put("query", query);
        model.put("domains", new Page<DomainItem>(pageable, domains.size(), domains));
        model.put("canCreateDomain", this.permissionsHelper.canCreateDomain());
        String output = this.renderTemplate("domains/index.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }

    @POST
    @Path(value="/create")
    @RolesAllowed(value={"admin", "user"})
    public Response create(@FormParam(value="domain") String domain, @FormParam(value="registrationEnabled") boolean registrationEnabled, UriInfo uriInfo) {
        if (!this.permissionsHelper.canCreateDomain()) {
            throw new HttpException("Forbidden", 403);
        }
        if (this.vHostManager.getVHostItem(domain) != null) {
            throw new HttpException("Domain already exist!", 409);
        }
        Packet iq = this.prepareVhostUpdatePacket(domain, command -> {
            Element x = command.getChild("x", "jabber:x:data");
            List toRemove = x.findChildren(el -> el.getName() == "field" && ("In-band registration".equals(el.getAttributeStaticStr("var")) || "Domain name".equals(el.getAttributeStaticStr("var"))));
            if (toRemove != null) {
                toRemove.forEach(arg_0 -> ((Element)x).removeChild(arg_0));
            }
            DataForm.addFieldValue((Element)command, (String)"Domain name", (String)domain);
            DataForm.addCheckBoxField((Element)command, (String)"In-band registration", (boolean)registrationEnabled);
        });
        this.applyChange(domain, DomainChangeEvent.Action.add, iq);
        return DomainsHandler.redirectToIndex(uriInfo, domain);
    }

    @POST
    @Path(value="/{domain}/changeStatus")
    @RolesAllowed(value={"admin", "user"})
    public Response changeStatus(@PathParam(value="domain") String domain, @FormParam(value="value") boolean value, SecurityContext securityContext, UriInfo uriInfo) {
        if (!this.permissionsHelper.canManageDomain(securityContext, domain)) {
            throw new HttpException("Forbidden", 403);
        }
        Packet iq = this.prepareVhostUpdatePacket(domain, command -> {
            Element x = command.getChild("x", "jabber:x:data");
            Element field = x.findChild(el -> el.getName() == "field" && "Enabled".equals(el.getAttributeStaticStr("var")));
            x.removeChild(field);
            DataForm.addCheckBoxField((Element)command, (String)"Enabled", (boolean)value);
        });
        this.applyChange(domain, DomainChangeEvent.Action.update, iq);
        return DomainsHandler.redirectToIndex(uriInfo);
    }

    @POST
    @Path(value="/{domain}/delete")
    @RolesAllowed(value={"admin", "user"})
    public Response delete(@PathParam(value="domain") String domain, SecurityContext securityContext, UriInfo uriInfo) {
        if (!this.permissionsHelper.canManageDomain(securityContext, domain)) {
            throw new HttpException("Forbidden", 403);
        }
        this.applyChange(domain, DomainChangeEvent.Action.remove, null);
        return DomainsHandler.redirectToIndex(uriInfo);
    }

    public void initialize() {
        this.eventBus.registerAll((Object)this);
    }

    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll((Object)this);
        }
    }

    private void applyChange(String domain, DomainChangeEvent.Action action, Packet iq) {
        if (iq != null) {
            VHostItem item = (VHostItem)this.vHostManager.getComponentRepository().getItemInstance();
            item.initFromCommand(iq);
            String error = this.vHostManager.getComponentRepository().validateItem((RepositoryItem)item);
            if (error != null) {
                throw new RuntimeException(error);
            }
        }
        this.eventBus.fire((EventBusEvent)new DomainChangeEvent(domain, action, iq == null ? null : iq.getElement()));
    }

    @HandleEvent(filter=HandleEvent.Type.all)
    private void handleEventDomain(DomainChangeEvent event) {
        try {
            VHostItem oldItem = this.vHostManager.getVHostItem(event.getDomain());
            switch (event.getAction()) {
                case add: {
                    if (oldItem == null) {
                        this.vHostManager.getComponentRepository().addItem((RepositoryItem)this.prepareVhostItem(event));
                    }
                    break;
                }
                case update: {
                    this.vHostManager.getComponentRepository().addItem((RepositoryItem)this.prepareVhostItem(event));
                    break;
                }
                case remove: {
                    this.vHostManager.getComponentRepository().removeItem(event.domain);
                }
            }
        }
        catch (TigaseDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String renderTemplate(String templateFile, Map<String, Object> model) {
        model.put("permissionsHelper", this.permissionsHelper);
        return super.renderTemplate(templateFile, model);
    }

    protected Packet prepareVhostUpdatePacket(String domain, Consumer<Element> commandConsumer) {
        VHostItem item = (VHostItem)this.vHostManager.getComponentRepository().getItem(domain);
        if (item == null) {
            item = (VHostItem)this.vHostManager.getComponentRepository().getItemInstance();
        }
        Element command = new Element("command");
        command.setXMLNS("http://jabber.org/protocol/commands");
        Element iqEl = new Element("iq");
        iqEl.addChild((XMLNodeIfc)command);
        Packet iq = Packet.packetInstance((Element)iqEl, null, (JID)JID.jidInstanceNS((String)SecurityContextHolder.getSecurityContext().getUserPrincipal().getName()));
        item.addCommandFields(iq);
        commandConsumer.accept(command);
        return iq;
    }

    protected VHostItem prepareVhostItem(DomainChangeEvent event) {
        if (event.getPacket() == null) {
            return null;
        }
        VHostItem item = (VHostItem)this.vHostManager.getComponentRepository().getItemInstance();
        Packet iq = Packet.packetInstance((Element)event.getPacket(), null, null);
        item.initFromCommand(iq);
        return item;
    }

    public static Response redirectToIndex(UriInfo uriInfo) {
        return DomainsHandler.redirectToIndex(uriInfo, null);
    }

    public static Response redirectToIndex(UriInfo uriInfo, String query) {
        return Response.seeOther((URI)uriInfo.getBaseUriBuilder().path(DomainsHandler.class, "index").replaceQueryParam("query", new Object[]{query}).build(new Object[0])).build();
    }

    public static class DomainChangeEvent
    implements EventBusEvent,
    Serializable {
        private String domain;
        private Element packet;
        private Action action;

        public DomainChangeEvent(String domain, Action action, Element packet) {
            this.domain = domain;
            this.action = action;
            this.packet = packet;
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public Element getPacket() {
            return this.packet;
        }

        public void setPacket(Element packet) {
            this.packet = packet;
        }

        public static enum Action {
            add,
            update,
            remove;

        }
    }

    public record DomainItem(String domain, VHostItem item, long noOfUsers) {
        public boolean isEnabled() {
            return this.item != null && this.item.isEnabled();
        }
    }
}

