/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tigase.http.DeploymentInfo;
import tigase.http.HttpMessageReceiver;
import tigase.http.ServletInfo;
import tigase.http.jaxrs.AbstractJaxRsModule;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.JaxRsServlet;
import tigase.http.util.AssetsServlet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;

@Bean(name="dashboard", parent=HttpMessageReceiver.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class DashboardModule
extends AbstractJaxRsModule<Handler> {
    private DeploymentInfo httpDeployment;
    @ConfigField(desc="Custom assets path", alias="customAssetsPath")
    private String customAssetsPath;
    @ConfigField(desc="Cache custom assets paths", alias="customAssetsPathCached")
    private boolean customAssetsPathCached = true;
    private CustomAssets customAssets;

    @Override
    public String getDescription() {
        return "Dashboard of Tigase XMPP Server";
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        super.start();
        if (this.customAssetsPathCached && this.customAssetsPath != null) {
            this.customAssets = this.resolveAssets();
        }
        this.httpDeployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setAuthProvider(this.getAuthProvider()).setDeploymentName("Dashboard").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        ServletInfo servletInfo = this.httpServer.servlet("JaxRsServlet", JaxRsServlet.class);
        servletInfo.addInitParam("module-uuid", this.uuid).addMapping("/*");
        this.httpDeployment.addServlets(servletInfo);
        servletInfo = this.httpServer.servlet("AssetsServlet", AssetsServlet.class);
        servletInfo.addInitParam("customAssetsPath", this.customAssetsPath);
        servletInfo.addMapping("/assets/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpDeployment.setGlobalErrorPage("/error/global");
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        this.customAssets = null;
        super.stop();
    }

    public CustomAssets getCustomAssets() {
        if (this.customAssetsPath == null) {
            return CustomAssets.NONE;
        }
        if (this.customAssets != null) {
            return this.customAssets;
        }
        return this.resolveAssets();
    }

    @Override
    public String getComponentName() {
        return super.getComponentName();
    }

    private CustomAssets resolveAssets() {
        if (this.customAssetsPath == null) {
            return null;
        }
        Path root = Paths.get(URI.create("file:///" + this.customAssetsPath));
        ArrayList<String> assets = new ArrayList<String>();
        File[] fileArray = root.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Path filePath = file.toPath();
            String assetPath = filePath.subpath(root.getNameCount(), filePath.getNameCount()).toString();
            assets.add(assetPath);
            ++n2;
        }
        return new CustomAssets(assets.stream().filter(it -> it.endsWith(".css")).toList(), assets.stream().filter(it -> it.endsWith(".js")).toList());
    }

    public record CustomAssets(List<String> cssFiles, List<String> jsFiles) {
        public static CustomAssets NONE = new CustomAssets(Collections.emptyList(), Collections.emptyList());
    }
}

