/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import tigase.db.TigaseDBException;
import tigase.http.AuthProvider;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.Model;
import tigase.http.jaxrs.annotations.LoginForm;
import tigase.http.modules.dashboard.DashboardHandler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.http.modules.dashboard.IndexHandler;
import tigase.http.modules.dashboard.UserPasswordRecovery;
import tigase.http.modules.dashboard.UserRegisterHandler;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Bean(name="authentication", parent=DashboardModule.class, active=true)
public class AuthHandler
extends DashboardHandler {
    @Inject
    private AuthProvider authProvider;
    @Inject(nullAllowed=true)
    private UserRegisterHandler userRegisterHandler;
    @Inject(nullAllowed=true)
    private UserPasswordRecovery userPasswordRecovery;

    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.None;
    }

    @GET
    @Path(value="/login")
    @LoginForm
    @Produces(value={"text/html"})
    public Response loginForm(UriInfo uriInfo, Model model) {
        model.put("registrationEnabled", this.userRegisterHandler != null && this.userRegisterHandler.isRegistrationEnabled());
        model.put("passwordResetEnabled", this.userPasswordRecovery != null && this.userPasswordRecovery.isPasswordResetEnabled());
        String output = this.renderTemplate("login.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }

    @POST
    @Path(value="/login")
    public Response login(@FormParam(value="jid") @NotEmpty BareJID jid, @FormParam(value="password") @NotBlank String password, HttpServletRequest request, HttpServletResponse response, UriInfo uriInfo, Model model) throws NoSuchAlgorithmException, InvalidKeyException, TigaseDBException, TigaseStringprepException {
        if (!this.authProvider.checkCredentials(jid.toString(), password)) {
            model.put("error", "Invalid username or password.");
            return this.loginForm(uriInfo, model);
        }
        this.authProvider.setAuthenticationCookie(response, new AuthProvider.JWTPayload(jid, request.getServerName(), LocalDateTime.now().plus(this.authProvider.getAuthenticationTokenValidityDuration())), request.getServerName(), request.getContextPath());
        return IndexHandler.redirectToIndex(uriInfo);
    }

    @POST
    @Path(value="/logout")
    public Response logout(HttpServletRequest request, HttpServletResponse response, UriInfo uriInfo) {
        this.authProvider.resetAuthenticationCookie(response, request.getServerName(), request.getContextPath());
        return IndexHandler.redirectToIndex(uriInfo);
    }
}

