/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules;

import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.WriterOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.http.DeploymentInfo;
import tigase.http.HttpMessageReceiver;
import tigase.http.ServletInfo;
import tigase.http.modules.AbstractModule;
import tigase.http.util.AssetsServlet;
import tigase.http.util.TemplateUtils;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;

@Bean(name="index", parent=HttpMessageReceiver.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class IndexModule
extends AbstractModule {
    private static final ConcurrentHashMap<String, IndexModule> modules = new ConcurrentHashMap();
    private final String uuid = UUID.randomUUID().toString();
    private DeploymentInfo httpDeployment = null;
    private TemplateEngine templateEngine;

    public static IndexModule getInstance(String uuid) {
        return modules.get(uuid);
    }

    public IndexModule() {
        this.contextPath = "/";
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.contextPath = "/";
    }

    @Override
    public String getDescription() {
        return "Index of all available HTTP endpoints";
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        this.templateEngine = TemplateUtils.create(null, "tigase.index", ContentType.Html);
        super.start();
        modules.put(this.uuid, this);
        this.httpDeployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setDeploymentName("Index").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        ServletInfo servletInfo = this.httpServer.servlet("AssetsServlet", AssetsServlet.class);
        servletInfo.addMapping("/assets/*");
        this.httpDeployment.addServlets(servletInfo);
        servletInfo = this.httpServer.servlet("IndexServlet", IndexServlet.class);
        servletInfo.addInitParam("module", this.uuid);
        servletInfo.addMapping("/");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        this.templateEngine = null;
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
        }
        modules.remove(this.uuid, this);
        super.stop();
    }

    protected List<DeploymentInfo> listDeployments() {
        return this.httpServer.listDeployed();
    }

    public static class IndexServlet
    extends HttpServlet {
        private IndexModule module;
        private TemplateEngine engine = null;

        public void init() throws ServletException {
            super.init();
            ServletConfig config = super.getServletConfig();
            String uuid = config.getInitParameter("module");
            if (uuid == null) {
                throw new ServletException("Missing module parameter!");
            }
            this.module = IndexModule.getInstance(uuid);
            if (this.module == null) {
                throw new ServletException("Not found module for IndexServlet");
            }
            this.engine = this.module.templateEngine;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            PrintWriter out = resp.getWriter();
            ArrayList<DeploymentInfo> deploymentInfoList = new ArrayList<DeploymentInfo>(this.module.listDeployments());
            deploymentInfoList.removeIf(info -> {
                if (info.getVHosts() != null && info.getVHosts().length > 0) {
                    List<String> vhosts = Arrays.asList(info.getVHosts());
                    return !vhosts.contains(req.getServerName());
                }
                return false;
            });
            deploymentInfoList.sort(Comparator.comparing(DeploymentInfo::getContextPath));
            HashMap<String, ArrayList<DeploymentInfo>> model = new HashMap<String, ArrayList<DeploymentInfo>>();
            model.put("deployments", deploymentInfoList);
            this.engine.render("index.jte", model, (TemplateOutput)new WriterOutput((Writer)out));
        }
    }
}

