/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jetty;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import tigase.http.AuthProvider;
import tigase.http.DeploymentInfo;
import tigase.http.ServletInfo;
import tigase.http.api.HttpServerIfc;
import tigase.http.java.filters.ProtocolRedirectFilter;
import tigase.http.jetty.security.BasicAndJWTAuthenticator;
import tigase.http.jetty.security.TigasePlainLoginService;

public class JettyHttpServerHelper {
    public static final String CONTEXT_KEY = "context-key";
    private static final Logger log = Logger.getLogger(JettyHttpServerHelper.class.getCanonicalName());

    public static ServletContextHandler createServletContextHandler(DeploymentInfo deployment, HttpServerIfc server) {
        ServletInfo[] servletInfos;
        String[] vhosts;
        ServletContextHandler context = new ServletContextHandler(0);
        try {
            context.setSecurityHandler((SecurityHandler)context.getDefaultSecurityHandlerClass().newInstance());
        }
        catch (InstantiationException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        AuthProvider authProvider = deployment.getAuthProvider();
        if (authProvider != null) {
            context.getSecurityHandler().setAuthenticator((Authenticator)new BasicAndJWTAuthenticator());
            context.getSecurityHandler().setLoginService((LoginService)new TigasePlainLoginService(authProvider));
        }
        context.setContextPath(deployment.getContextPath());
        if (deployment.getClassLoader() != null) {
            context.setClassLoader(deployment.getClassLoader());
        }
        if ((vhosts = deployment.getVHosts()) != null && vhosts.length > 0) {
            context.setVirtualHosts(vhosts);
        }
        ServletInfo[] servletInfoArray = servletInfos = deployment.getServlets();
        int n = servletInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ServletInfo info = servletInfoArray[n2];
            for (String mapping : info.getMappings()) {
                ServletHolder holder = new ServletHolder(mapping, info.getServletClass());
                holder.setInitParameters(info.getInitParams());
                context.addServlet(holder, mapping);
            }
            ++n2;
        }
        HashMap<String, String> filterParams = new HashMap<String, String>();
        filterParams.put("serverBeanName", server.getName());
        context.addFilter(ProtocolRedirectFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameters(Collections.unmodifiableMap(filterParams));
        Map<Class<? extends Throwable>, String> exceptionErrorPages = deployment.getExceptionErrorPages();
        Map<Integer, String> errorCodePages = deployment.getErrorCodePages();
        if (!exceptionErrorPages.isEmpty() || !errorCodePages.isEmpty() || deployment.getGlobalErrorPage() != null) {
            ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler(){

                public String getErrorPage(HttpServletRequest request) {
                    String accept = request.getHeader(HttpHeader.ACCEPT.asString());
                    if (accept == null || accept.contains("text/html")) {
                        return super.getErrorPage(request);
                    }
                    return null;
                }
            };
            exceptionErrorPages.forEach((arg_0, arg_1) -> ((ErrorPageErrorHandler)errorHandler).addErrorPage(arg_0, arg_1));
            errorCodePages.forEach((arg_0, arg_1) -> ((ErrorPageErrorHandler)errorHandler).addErrorPage(arg_0, arg_1));
            Optional.ofNullable(deployment.getGlobalErrorPage()).ifPresent(uri -> errorHandler.addErrorPage("org.eclipse.jetty.server.error_page.global", uri));
            context.setErrorHandler((ErrorHandler)errorHandler);
        }
        return context;
    }
}

