/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs.marshallers;

import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import tigase.http.jaxrs.marshallers.AbstractUnmarshaller;
import tigase.http.jaxrs.marshallers.Unmarshaller;
import tigase.http.jaxrs.marshallers.XmlMarshaller;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLUtils;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class XmlUnmarshaller
extends AbstractUnmarshaller
implements Unmarshaller {
    private static final String DEFAULT = "##default";
    private static final SimpleParser PARSER = SingletonFactory.getParserInstance();
    private static final Map<Class, Function<String, Object>> DEFAULT_DESERIALIZERS = new HashMap<Class, Function<String, Object>>();
    private final Map<Class, Function<String, Object>> DESERIALIZERS = new HashMap<Class, Function<String, Object>>(DEFAULT_DESERIALIZERS);

    static {
        DEFAULT_DESERIALIZERS.put(Long.class, Long::parseLong);
        DEFAULT_DESERIALIZERS.put(Double.class, Double::parseDouble);
        DEFAULT_DESERIALIZERS.put(Integer.class, Integer::parseInt);
        DEFAULT_DESERIALIZERS.put(Float.class, Float::parseFloat);
        DEFAULT_DESERIALIZERS.put(UUID.class, UUID::fromString);
        DEFAULT_DESERIALIZERS.put(LocalTime.class, LocalTime::parse);
        DEFAULT_DESERIALIZERS.put(ZonedDateTime.class, str -> ZonedDateTime.parse(str, DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        DEFAULT_DESERIALIZERS.put(LocalDateTime.class, LocalDateTime::parse);
        DEFAULT_DESERIALIZERS.put(LocalDate.class, LocalDate::parse);
        DEFAULT_DESERIALIZERS.put(String.class, obj -> obj);
        DEFAULT_DESERIALIZERS.put(Date.class, str -> Date.from(ZonedDateTime.parse(str, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant()));
        DEFAULT_DESERIALIZERS.put(JID.class, JID::jidInstanceNS);
        DEFAULT_DESERIALIZERS.put(BareJID.class, BareJID::bareJIDInstanceNS);
    }

    public static boolean isNotDefault(String value) {
        return !DEFAULT.equals(value);
    }

    @Override
    public Object unmarshal(Class clazz, Reader inReader) throws UnmarshalException, IOException {
        DomBuilderHandler handler = new DomBuilderHandler();
        Element root = null;
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedReader reader = new BufferedReader(inReader);){
            String inData = reader.lines().collect(Collectors.joining("\n"));
            PARSER.parse((SimpleHandler)handler, inData);
            root = (Element)handler.getParsedElements().poll();
            if (root == null) {
                throw new UnmarshalException("Could not parse XML: " + inData);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        XmlRootElement xmlRootElement = clazz.getAnnotation(XmlRootElement.class);
        String name = Optional.ofNullable(xmlRootElement).map(XmlRootElement::name).filter(XmlUnmarshaller::isNotDefault).orElse(clazz.getSimpleName());
        Optional<String> namespace = Optional.ofNullable(xmlRootElement).map(XmlRootElement::namespace).filter(XmlUnmarshaller::isNotDefault);
        return this.unmarshal(clazz, name, namespace, root);
    }

    protected Object unmarshal(Class clazz, String name, Optional<String> namespace, Element root) throws UnmarshalException {
        if (!name.equals(root.getName())) {
            throw new UnmarshalException("Invalid element name, expected " + name + ", got " + root.getName());
        }
        if (namespace.isPresent() && namespace.filter(ns -> ns.equals(root.getXMLNS())).isEmpty()) {
            throw new UnmarshalException("Invalid element namespace, expected " + namespace.get() + ", got " + root.getXMLNS());
        }
        try {
            Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Field[] fields = clazz.getDeclaredFields();
            List attributeFields = Arrays.stream(fields).filter(field -> field.getAnnotation(XmlAttribute.class) != null).collect(Collectors.toList());
            for (Field field2 : attributeFields) {
                Object value;
                String valueStr = root.getAttribute(Optional.ofNullable(field2.getAnnotation(XmlAttribute.class)).map(XmlAttribute::name).filter(XmlMarshaller::isNotDefault).orElse(field2.getName()));
                if (valueStr == null || (value = this.deserialize(field2.getClass(), valueStr)) == null) continue;
                this.setFieldValue(object, field2, value);
            }
            List elementFields = Arrays.stream(fields).filter(field -> field.getAnnotation(XmlAttribute.class) == null).collect(Collectors.toList());
            for (Field field3 : elementFields) {
                Object value;
                String fieldName = Optional.ofNullable(field3.getAnnotation(XmlAttribute.class)).map(XmlAttribute::name).filter(XmlMarshaller::isNotDefault).orElse(field3.getName());
                if (Collection.class.isAssignableFrom(field3.getType())) {
                    List elems = root.findChildren(el -> fieldName.equals(el.getName()));
                    if (elems == null) continue;
                    Collection collection = this.createCollectionInstance(field3.getType());
                    for (Element elem : elems) {
                        Object value2 = this.deserializeValue((Class)((ParameterizedType)field3.getGenericType()).getActualTypeArguments()[0], fieldName, elem);
                        if (value2 == null) continue;
                        collection.add(value2);
                    }
                    this.setFieldValue(object, field3, collection);
                    continue;
                }
                Element elem = root.findChild(el -> fieldName.equals(el.getName()));
                if (elem == null || (value = this.deserializeValue(field3.getType(), fieldName, elem)) == null) continue;
                this.setFieldValue(object, field3, value);
            }
            return object;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnmarshalException("Could not unmarshal instance of " + clazz.getName(), (Throwable)e);
        }
    }

    protected Collection createCollectionInstance(Class<Collection> collectionClass) throws UnmarshalException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (Modifier.isAbstract(collectionClass.getModifiers()) || Modifier.isInterface(collectionClass.getModifiers())) {
            if (List.class.isAssignableFrom(collectionClass)) {
                return new ArrayList();
            }
            if (Set.class.isAssignableFrom(collectionClass)) {
                return new HashSet();
            }
            throw new UnmarshalException("Unsupported collection class " + collectionClass.getName());
        }
        return collectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected Object deserializeValue(Class clazz, String name, Element elem) throws NoSuchFieldException, UnmarshalException {
        Object value;
        String valueStr = XMLUtils.unescape((String)elem.getCData());
        if (valueStr != null && (value = this.deserialize(clazz, valueStr)) != null) {
            return value;
        }
        Field field = clazz.getDeclaredField(name);
        Optional<String> namespace = Optional.ofNullable(field.getAnnotation(XmlElement.class)).map(XmlElement::namespace).filter(XmlMarshaller::isNotDefault).or(() -> Optional.ofNullable(field.getClass().getAnnotation(XmlRootElement.class)).map(XmlRootElement::namespace).filter(XmlMarshaller::isNotDefault));
        return this.unmarshal(clazz, name, namespace, elem);
    }

    protected Object deserialize(Class clazz, String valueStr) throws UnmarshalException {
        Function<String, Object> serializer = this.DESERIALIZERS.get(clazz);
        if (serializer == null) {
            if (Enum.class.isAssignableFrom(clazz)) {
                try {
                    return Enum.valueOf(clazz, valueStr);
                }
                catch (IllegalArgumentException ex) {
                    throw new UnmarshalException("Invalid value " + valueStr + " for enum " + clazz.getName(), (Throwable)ex);
                }
            }
            return null;
        }
        return serializer.apply(valueStr);
    }

    protected void setFieldValue(Object object, Field field, Object value) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = object.getClass().getDeclaredMethod("set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1), field.getType());
        method.invoke(object, value);
    }
}

