/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs.marshallers;

import jakarta.xml.bind.UnmarshalException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import tigase.http.jaxrs.marshallers.AbstractUnmarshaller;
import tigase.http.jaxrs.marshallers.Unmarshaller;
import tigase.http.json.JsonParser;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class JsonUnmarshaller
extends AbstractUnmarshaller
implements Unmarshaller {
    private static final Map<Class, Function<Object, Object>> DEFAULT_DESERIALIZERS = new HashMap<Class, Function<Object, Object>>();
    private final Map<Class, Function<Object, Object>> DESERIALIZERS = new HashMap<Class, Function<Object, Object>>(DEFAULT_DESERIALIZERS);

    static {
        DEFAULT_DESERIALIZERS.put(Long.class, obj -> ((Number)obj).longValue());
        DEFAULT_DESERIALIZERS.put(Double.class, obj -> ((Number)obj).doubleValue());
        DEFAULT_DESERIALIZERS.put(Integer.class, obj -> ((Number)obj).intValue());
        DEFAULT_DESERIALIZERS.put(Float.class, obj -> Float.valueOf(((Number)obj).floatValue()));
        DEFAULT_DESERIALIZERS.put(UUID.class, obj -> UUID.fromString((String)obj));
        DEFAULT_DESERIALIZERS.put(LocalTime.class, obj -> LocalTime.parse((String)obj));
        DEFAULT_DESERIALIZERS.put(ZonedDateTime.class, str -> ZonedDateTime.parse((String)str, DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        DEFAULT_DESERIALIZERS.put(LocalDateTime.class, obj -> LocalDateTime.parse((String)obj));
        DEFAULT_DESERIALIZERS.put(LocalDate.class, obj -> LocalDate.parse((String)obj));
        DEFAULT_DESERIALIZERS.put(String.class, obj -> obj);
        DEFAULT_DESERIALIZERS.put(Date.class, obj -> Date.from(ZonedDateTime.parse((String)obj, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant()));
        DEFAULT_DESERIALIZERS.put(JID.class, obj -> JID.jidInstanceNS((String)((String)obj)));
        DEFAULT_DESERIALIZERS.put(BareJID.class, obj -> BareJID.bareJIDInstanceNS((String)((String)obj)));
    }

    @Override
    public Object unmarshal(Class clazz, Reader inReader) throws UnmarshalException, IOException {
        Map root;
        Throwable throwable = null;
        Object var5_5 = null;
        try (BufferedReader reader = new BufferedReader(inReader);){
            String inData = reader.lines().collect(Collectors.joining("\n"));
            try {
                root = (Map)new JsonParser().parse(inData);
            }
            catch (JsonParser.InvalidJsonException invalidJsonException) {
                throw new UnmarshalException("Could not parse JSON: " + inData);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (root == null) {
            return null;
        }
        return this.unmarshal(clazz, root);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object unmarshal(Class clazz, Map<String, Object> root) throws UnmarshalException {
        try {
            Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Object value = root.get(field.getName());
                if (value != null) {
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        if (!(value instanceof Collection)) throw new UnmarshalException("Invalid value for field " + field.getName());
                        Collection collection = this.createCollectionInstance(field.getType());
                        for (Object item : (Collection)value) {
                            Object v = this.deserializeValue((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0], item);
                            if (v == null) continue;
                            collection.add(v);
                        }
                        this.setFieldValue(object, field, collection);
                    } else {
                        Object v = this.deserializeValue(field.getType(), value);
                        if (v != null) {
                            this.setFieldValue(object, field, v);
                        }
                    }
                }
                ++n2;
            }
            return object;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnmarshalException("Could not unmarshal instance of " + clazz.getName(), (Throwable)e);
        }
    }

    protected Object deserializeValue(Class clazz, Object value) throws NoSuchFieldException, UnmarshalException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (clazz.isAssignableFrom(value.getClass())) {
            return value;
        }
        Object v = this.deserialize(clazz, value);
        if (v != null) {
            return v;
        }
        return this.unmarshal(clazz, (Map)value);
    }

    protected Object deserialize(Class clazz, Object value) throws UnmarshalException {
        Function<Object, Object> serializer = this.DESERIALIZERS.get(clazz);
        if (serializer == null) {
            if (Enum.class.isAssignableFrom(clazz)) {
                try {
                    return Enum.valueOf(clazz, value.toString());
                }
                catch (IllegalArgumentException ex) {
                    throw new UnmarshalException("Invalid value " + String.valueOf(value) + " for enum " + clazz.getName(), (Throwable)ex);
                }
            }
            return null;
        }
        try {
            return serializer.apply(value);
        }
        catch (ClassCastException ex) {
            throw new UnmarshalException("Failed to convert " + String.valueOf(value.getClass()) + " to " + clazz.getName(), (Throwable)ex);
        }
    }

    protected Collection createCollectionInstance(Class<Collection> collectionClass) throws UnmarshalException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (Modifier.isAbstract(collectionClass.getModifiers()) || Modifier.isInterface(collectionClass.getModifiers())) {
            if (List.class.isAssignableFrom(collectionClass)) {
                return new ArrayList();
            }
            if (Set.class.isAssignableFrom(collectionClass)) {
                return new HashSet();
            }
            throw new UnmarshalException("Unsupported collection class " + collectionClass.getName());
        }
        return collectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void setFieldValue(Object object, Field field, Object value) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        try {
            Method method = object.getClass().getDeclaredMethod("set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1), field.getType());
            method.invoke(object, value);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Could not set " + String.valueOf(value) + "/" + String.valueOf(value.getClass()) + " to field " + field.getName());
            throw ex;
        }
    }
}

