/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import tigase.http.jaxrs.MultivaluedMapImpl;

public class UriInfoImpl
implements UriInfo {
    private final String baseUri;
    private final HttpServletRequest request;

    public UriInfoImpl(HttpServletRequest request, String baseUri) {
        this.request = request;
        this.baseUri = baseUri;
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        if (!decode) {
            throw new RuntimeException("Encoded path is not supported!");
        }
        return this.request.getPathInfo();
    }

    public List<PathSegment> getPathSegments() {
        throw new RuntimeException("Path segments are not supported!");
    }

    public List<PathSegment> getPathSegments(boolean b) {
        throw new RuntimeException("Path segments are not supported!");
    }

    public URI getRequestUri() {
        return this.getRequestUriBuilder().build(new Object[0]);
    }

    public UriBuilder getRequestUriBuilder() {
        UriBuilder builder = UriBuilder.fromPath((String)this.request.getRequestURI());
        for (Map.Entry e : this.request.getParameterMap().entrySet()) {
            builder.replaceQueryParam((String)e.getKey(), (Object[])e.getValue());
        }
        return builder;
    }

    public URI getAbsolutePath() {
        return this.getAbsolutePathBuilder().build(new Object[0]);
    }

    public UriBuilder getAbsolutePathBuilder() {
        return this.getRequestUriBuilder().scheme(this.request.getScheme()).host(this.request.getServerName()).port(this.request.getLocalPort());
    }

    public URI getBaseUri() {
        return this.getBaseUriBuilder().build(new Object[0]);
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.newInstance().scheme(this.request.getScheme()).host(this.request.getServerName()).port(this.request.getServerPort()).path(this.baseUri);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        throw new RuntimeException("Path parameters are not supported!");
    }

    public MultivaluedMap<String, String> getPathParameters(boolean b) {
        throw new RuntimeException("Path parameters are not supported!");
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return MultivaluedMapImpl.fromArrayMap(this.request.getParameterMap());
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean b) {
        return this.getQueryParameters();
    }

    public List<String> getMatchedURIs() {
        throw new RuntimeException("Matched URIs are not supported!");
    }

    public List<String> getMatchedURIs(boolean b) {
        return this.getMatchedURIs();
    }

    public List<Object> getMatchedResources() {
        throw new RuntimeException("Matched resources are not supported!");
    }

    public URI resolve(URI uri) {
        return this.getBaseUri().resolve(uri);
    }

    public URI relativize(URI uri) {
        throw new RuntimeException("Relativize is not supported!");
    }
}

