/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import tigase.http.jaxrs.MultivaluedMapImpl;

public class ResponseImpl
extends Response {
    private final Object entity;
    private final int status;
    private final String reasonPhase;
    private final MultivaluedMap<String, Object> metadata;

    public ResponseImpl(int status, String reasonPhase, MultivaluedMap<String, Object> metadata, Object entity) {
        this.status = status;
        this.reasonPhase = reasonPhase;
        this.metadata = metadata;
        this.entity = entity;
    }

    public int getStatus() {
        return this.status;
    }

    public Response.StatusType getStatusInfo() {
        return new Response.StatusType(){

            public int getStatusCode() {
                return ResponseImpl.this.status;
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)ResponseImpl.this.status);
            }

            public String getReasonPhrase() {
                return ResponseImpl.this.reasonPhase;
            }
        };
    }

    public Object getEntity() {
        return this.entity;
    }

    public <T> T readEntity(Class<T> aClass) {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public <T> T readEntity(GenericType<T> genericType) {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public <T> T readEntity(Class<T> aClass, Annotation[] annotations) {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public <T> T readEntity(GenericType<T> genericType, Annotation[] annotations) {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public boolean bufferEntity() {
        return false;
    }

    public void close() {
    }

    public MediaType getMediaType() {
        String[] parts;
        String fullType;
        Object obj;
        block20: {
            MediaType decodedType;
            obj = this.metadata.getFirst((Object)"Content-Type");
            if (obj instanceof MediaType) {
                return (MediaType)obj;
            }
            if (obj == null) {
                return null;
            }
            String str = obj.toString();
            int idx = str.indexOf(";");
            String string = fullType = idx < 0 ? str : str.substring(0, idx);
            if (idx >= 0) break block20;
            switch (fullType) {
                case "*/*": {
                    MediaType mediaType = MediaType.WILDCARD_TYPE;
                    break;
                }
                case "application/json": {
                    MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;
                    break;
                }
                case "application/xml": {
                    MediaType mediaType = MediaType.APPLICATION_XML_TYPE;
                    break;
                }
                case "text/html": {
                    MediaType mediaType = MediaType.TEXT_HTML_TYPE;
                    break;
                }
                default: {
                    MediaType mediaType = decodedType = null;
                }
            }
            if (decodedType != null) {
                return decodedType;
            }
        }
        if ((parts = fullType.split("/")).length != 2) {
            return null;
        }
        return MediaType.valueOf((String)this.toHeaderString(obj));
    }

    public Locale getLanguage() {
        Object obj = this.metadata.getFirst((Object)"Content-Language");
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj == null) {
            return null;
        }
        return Locale.forLanguageTag(obj.toString());
    }

    public int getLength() {
        return -1;
    }

    public Set<String> getAllowedMethods() {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public Map<String, NewCookie> getCookies() {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public EntityTag getEntityTag() {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public Date getDate() {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public Date getLastModified() {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public URI getLocation() {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public Set<Link> getLinks() {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public boolean hasLink(String s) {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public Link getLink(String s) {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public Link.Builder getLinkBuilder(String s) {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.metadata;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        for (Map.Entry entry : this.metadata.entrySet()) {
            for (Object it : (List)entry.getValue()) {
                headers.add((String)entry.getKey(), this.toHeaderString(it));
            }
        }
        return headers;
    }

    public String getHeaderString(String s) {
        throw new UnsupportedOperationException("Feature not implemented");
    }

    private String toHeaderString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof MediaType) {
            MediaType type = (MediaType)object;
            StringBuilder sb = new StringBuilder();
            sb.append(type.getType()).append("/").append(type.getSubtype());
            for (Map.Entry it : type.getParameters().entrySet()) {
                sb.append("; ").append((String)it.getKey()).append("=\"").append((String)it.getValue()).append("\"");
            }
            return sb.toString();
        }
        if (object instanceof Date) {
            return ResponseBuilderImpl.getDateFormatRFC822().format((Date)object);
        }
        return object.toString();
    }

    public static class ResponseBuilderImpl
    extends Response.ResponseBuilder {
        private Object entity;
        private int status = -1;
        private String reasonPhase;
        private MultivaluedMap<String, Object> metadata = new MultivaluedMapImpl();

        public static SimpleDateFormat getDateFormatRFC822() {
            SimpleDateFormat dateFormatRFC822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            dateFormatRFC822.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateFormatRFC822;
        }

        public Response build() {
            if (this.status == -1) {
                this.status = this.entity == null ? 204 : 200;
            }
            return new ResponseImpl(this.status, this.reasonPhase, this.metadata, this.entity);
        }

        public Response.ResponseBuilder clone() {
            return null;
        }

        public Response.ResponseBuilder status(int status) {
            return this.status(status, null);
        }

        public Response.ResponseBuilder status(int status, String reasonPhase) {
            this.status = status;
            this.reasonPhase = reasonPhase;
            return this;
        }

        public Response.ResponseBuilder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        public Response.ResponseBuilder entity(Object o, Annotation[] annotations) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder allow(String ... strings) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder allow(Set<String> set) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
            if (cacheControl == null) {
                this.metadata.remove((Object)"Cache-Control");
                return this;
            }
            this.metadata.putSingle((Object)"Cache-Control", (Object)cacheControl);
            return this;
        }

        public Response.ResponseBuilder encoding(String s) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder header(String name, Object value) {
            if (value == null) {
                this.metadata.remove((Object)name);
                return this;
            }
            this.metadata.add((Object)name, value);
            return this;
        }

        public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> multivaluedMap) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder language(String language) {
            if (language == null) {
                this.metadata.remove((Object)"Content-Language");
                return this;
            }
            this.metadata.putSingle((Object)"Content-Language", (Object)language);
            return this;
        }

        public Response.ResponseBuilder language(Locale language) {
            if (language == null) {
                this.metadata.remove((Object)"Content-Language");
                return this;
            }
            this.metadata.putSingle((Object)"Content-Language", (Object)language);
            return this;
        }

        public Response.ResponseBuilder type(MediaType mediaType) {
            if (mediaType == null) {
                this.metadata.remove((Object)"Content-Type");
            } else {
                this.metadata.putSingle((Object)"Content-Type", (Object)mediaType);
            }
            return this;
        }

        public Response.ResponseBuilder type(String mediaType) {
            if (mediaType == null) {
                this.metadata.remove((Object)"Content-Type");
            } else {
                this.metadata.putSingle((Object)"Content-Type", (Object)mediaType);
            }
            return this;
        }

        public Response.ResponseBuilder variant(Variant variant) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder contentLocation(URI uri) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder cookie(NewCookie ... newCookies) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder expires(Date expires) {
            if (expires == null) {
                this.metadata.remove((Object)"Expires");
                return this;
            }
            this.metadata.putSingle((Object)"Expires", (Object)ResponseBuilderImpl.getDateFormatRFC822().format(expires));
            return this;
        }

        public Response.ResponseBuilder lastModified(Date lastModified) {
            if (lastModified == null) {
                this.metadata.remove((Object)"Last-Modified");
                return this;
            }
            this.metadata.putSingle((Object)"Last-Modified", (Object)lastModified);
            return this;
        }

        public Response.ResponseBuilder location(URI location) {
            if (location == null) {
                this.metadata.remove((Object)"Location");
                return this;
            }
            if (!location.isAbsolute()) {
                throw new UnsupportedOperationException("Feature not implemented");
            }
            this.metadata.putSingle((Object)"Location", (Object)location);
            return this;
        }

        public Response.ResponseBuilder tag(EntityTag entityTag) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder tag(String s) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder variants(Variant ... variants) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder variants(List<Variant> list) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder links(Link ... links) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder link(URI uri, String s) {
            throw new UnsupportedOperationException("Feature not implemented");
        }

        public Response.ResponseBuilder link(String s, String s1) {
            throw new UnsupportedOperationException("Feature not implemented");
        }
    }
}

