/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import tigase.http.jaxrs.Sort;

public record Pageable(int pageNumber, int pageSize, Sort sort) {
    public static Pageable from(HttpServletRequest request) {
        int page = Optional.ofNullable(request.getParameter("page")).map(Integer::parseInt).orElse(0);
        int size = Optional.ofNullable(request.getParameter("size")).map(Integer::parseInt).orElse(30);
        Sort sort = Optional.ofNullable(request.getParameter("sort")).map(Sort::valueOf).orElse(Sort.asc);
        return new Pageable(page, size, sort);
    }

    public int offset() {
        return this.pageSize * this.pageNumber;
    }

    public Pageable next() {
        return new Pageable(this.pageNumber + 1, this.pageSize, this.sort);
    }

    public Pageable previous() {
        return new Pageable(this.pageNumber - 1, this.pageSize, this.sort);
    }
}

