/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.xml.bind.MarshalException;
import jakarta.xml.bind.UnmarshalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import tigase.http.api.HttpException;
import tigase.http.api.UnsupportedFormatException;
import tigase.http.jaxrs.AcceptedType;
import tigase.http.jaxrs.AsyncResponseImpl;
import tigase.http.jaxrs.ContainerRequestContext;
import tigase.http.jaxrs.ExtendedValidationException;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.HttpMethod;
import tigase.http.jaxrs.Model;
import tigase.http.jaxrs.Pageable;
import tigase.http.jaxrs.RequestHandler;
import tigase.http.jaxrs.marshallers.JsonMarshaller;
import tigase.http.jaxrs.marshallers.JsonUnmarshaller;
import tigase.http.jaxrs.marshallers.Marshaller;
import tigase.http.jaxrs.marshallers.Unmarshaller;
import tigase.http.jaxrs.marshallers.WWWFormUrlEncodedUnmarshaller;
import tigase.http.jaxrs.marshallers.XmlMarshaller;
import tigase.http.jaxrs.marshallers.XmlUnmarshaller;
import tigase.http.jaxrs.validators.ConstraintViolation;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class JaxRsRequestHandler
implements RequestHandler {
    private static final Logger log = Logger.getLogger(JaxRsRequestHandler.class.getCanonicalName());
    private static final Map<Class, Function<String, Object>> DESERIALIZERS = new HashMap<Class, Function<String, Object>>();
    private final Handler.Role requiredRole;
    private final Set<String> allowedRoles;
    private final Handler handler;
    private final Method method;
    private final java.util.regex.Pattern pattern;
    private final HttpMethod httpMethod;
    private final Set<String> consumedContentTypes;
    private final Set<String> producedContentTypes;

    static {
        DESERIALIZERS.put(Long.TYPE, Long::parseLong);
        DESERIALIZERS.put(Integer.TYPE, Integer::parseInt);
        DESERIALIZERS.put(Long.class, Long::parseLong);
        DESERIALIZERS.put(Integer.class, Integer::parseInt);
        DESERIALIZERS.put(Double.class, Double::parseDouble);
        DESERIALIZERS.put(Float.class, Float::parseFloat);
        DESERIALIZERS.put(String.class, s -> {
            if (s.isEmpty()) {
                return null;
            }
            return s;
        });
        DESERIALIZERS.put(BareJID.class, str -> {
            try {
                return BareJID.bareJIDInstance((String)str);
            }
            catch (TigaseStringprepException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        });
        DESERIALIZERS.put(JID.class, str -> {
            try {
                return JID.jidInstance((String)str);
            }
            catch (TigaseStringprepException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        });
    }

    public static List<JaxRsRequestHandler> create(Handler instance) {
        Method[] methods;
        Path path = instance.getClass().getAnnotation(Path.class);
        ArrayList<JaxRsRequestHandler> handlers = new ArrayList<JaxRsRequestHandler>();
        Method[] methodArray = methods = instance.getClass().getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method;
            JaxRsRequestHandler handler = JaxRsRequestHandler.create(path == null ? "" : path.value(), instance, method = methodArray[n2]);
            if (handler != null) {
                handlers.add(handler);
            }
            ++n2;
        }
        return handlers;
    }

    public static JaxRsRequestHandler create(String contextPath, Handler instance, Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        HttpMethod httpMethod = JaxRsRequestHandler.getHttpMethod(method);
        if (httpMethod == null) {
            return null;
        }
        Set<String> allowedRoles = Handler.getAllowedRoles(method);
        String methodPath = Optional.ofNullable(method.getAnnotation(Path.class)).map(Path::value).orElse("");
        Object fullPath = contextPath;
        if (!methodPath.isEmpty() && !methodPath.startsWith("/")) {
            fullPath = (String)fullPath + "/";
        }
        fullPath = (String)fullPath + methodPath;
        java.util.regex.Pattern pattern = JaxRsRequestHandler.prepareMatcher((String)fullPath, method);
        return new JaxRsRequestHandler(instance, method, httpMethod, pattern, instance.getRequiredRole(), allowedRoles);
    }

    public static HttpMethod getHttpMethod(Method method) {
        if (method.getAnnotation(GET.class) != null) {
            return HttpMethod.GET;
        }
        if (method.getAnnotation(POST.class) != null) {
            return HttpMethod.POST;
        }
        if (method.getAnnotation(PUT.class) != null) {
            return HttpMethod.PUT;
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return HttpMethod.DELETE;
        }
        return null;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    public Method getMethod() {
        return this.method;
    }

    public java.util.regex.Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public Set<String> getAllowedRoles() {
        return this.allowedRoles;
    }

    @Override
    public Handler.Role getRequiredRole() {
        return this.requiredRole;
    }

    @Override
    public boolean isAuthenticationRequired() {
        return RequestHandler.super.isAuthenticationRequired() || this.allowedRoles != null;
    }

    public static java.util.regex.Pattern prepareMatcher(String path, Method method) {
        Map<String, Class> paramClasses = JaxRsRequestHandler.methodsPathParams(method);
        int idx = -1;
        ArrayList<Param> params = new ArrayList<Param>();
        while ((idx = path.indexOf(123, idx + 1)) > -1) {
            int startIdx = idx;
            int endIdx = idx;
            while ((endIdx = path.indexOf(125, endIdx)) > -1 && path.charAt(endIdx) == '\\') {
            }
            if (endIdx == -1) {
                return null;
            }
            String paramName = path.substring(idx + 1, endIdx).trim();
            String paramRegex = JaxRsRequestHandler.regexForClass(paramClasses.get(paramName));
            if (paramRegex == null) {
                return null;
            }
            params.add(new Param(paramName, paramRegex, startIdx, endIdx + 1));
        }
        Object regex = path;
        int i = params.size() - 1;
        while (i >= 0) {
            Param param = (Param)params.get(i);
            String prefix = ((String)regex).substring(0, param.startIdx);
            String suffix = ((String)regex).substring(param.endIdx);
            regex = prefix + "(?<" + param.name + ">" + param.regex + ")" + suffix;
            --i;
        }
        return java.util.regex.Pattern.compile((String)regex);
    }

    private static String regexForClass(Class clazz) {
        if (Long.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return "[0-9]+";
        }
        if (String.class.isAssignableFrom(clazz)) {
            return "[^\\/]+";
        }
        if (BareJID.class.isAssignableFrom(clazz)) {
            return "[^\\/]+";
        }
        try {
            Method m = clazz.getDeclaredMethod("fromString", String.class);
            if (Modifier.isStatic(m.getModifiers())) {
                return "[^\\/]+";
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Method m = clazz.getDeclaredMethod("valueOf", String.class);
                if (Modifier.isStatic(m.getModifiers())) {
                    return "[^\\/]+";
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.log(Level.FINEST, "Method 'fromString' or 'valueOf' for conversation to object from String not found", e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static Map<String, Class> methodsPathParams(Method method) {
        HashMap<String, Class> params = new HashMap<String, Class>();
        Parameter[] parameterArray = method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            PathParam pathParam = parameter.getAnnotation(PathParam.class);
            if (pathParam != null) {
                params.put(pathParam.value(), parameter.getType());
            }
            ++n2;
        }
        return params;
    }

    public JaxRsRequestHandler(Handler handler, Method method, HttpMethod httpMethod, java.util.regex.Pattern pattern, Handler.Role requiredRole, Set<String> allowedRoles) {
        this.requiredRole = requiredRole;
        this.httpMethod = httpMethod;
        this.handler = handler;
        this.method = method;
        this.pattern = pattern;
        this.allowedRoles = allowedRoles;
        Consumes consumes = method.getAnnotation(Consumes.class);
        this.consumedContentTypes = consumes != null ? Arrays.stream(consumes.value()).collect(Collectors.toSet()) : Collections.emptySet();
        Produces produces = method.getAnnotation(Produces.class);
        this.producedContentTypes = produces != null ? Arrays.stream(produces.value()).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public Matcher test(HttpServletRequest request, String requestUri) {
        if (this.consumedContentTypes.contains(request.getContentType()) || this.consumedContentTypes.isEmpty()) {
            String header = request.getHeader("Accept");
            if (header != null && !this.producedContentTypes.isEmpty() && Arrays.stream(header.split(",")).map(AcceptedType::new).filter(it -> this.producedContentTypes.contains(it.getMimeType())).sorted(Comparator.comparing(AcceptedType::getPreference).reversed()).findFirst().map(AcceptedType::getMimeType).isEmpty()) {
                return null;
            }
            return this.pattern.matcher(requestUri);
        }
        return null;
    }

    private String getParameterNameDescription(Parameter param) {
        PathParam pathParam = param.getAnnotation(PathParam.class);
        HeaderParam headerParam = param.getAnnotation(HeaderParam.class);
        FormParam formParam = param.getAnnotation(FormParam.class);
        QueryParam queryParam = param.getAnnotation(QueryParam.class);
        if (pathParam != null) {
            return "Parameter '" + pathParam.value() + "'";
        }
        if (headerParam != null) {
            return "Header '" + headerParam.value() + "'";
        }
        if (formParam != null) {
            return "Form parameter '" + formParam.value() + "'";
        }
        if (queryParam != null) {
            return "Query parameter '" + queryParam.value() + "'";
        }
        return "Unknown " + param.getName();
    }

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, Matcher matcher, ScheduledExecutorService executorService) throws HttpException, IOException {
        block50: {
            ContainerRequestContext context = new ContainerRequestContext(request);
            Optional<String> acceptedType = this.selectResponseMimeType(this.method, request);
            ArrayList<Object> values = new ArrayList<Object>();
            AsyncResponseImpl asyncResponse = null;
            try {
                ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
                HashMap<Parameter, ValidationException> parsingExceptions = new HashMap<Parameter, ValidationException>();
                Parameter[] parameterArray = this.method.getParameters();
                int n = parameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value;
                    block49: {
                        Parameter param = parameterArray[n2];
                        value = null;
                        PathParam pathParam = param.getAnnotation(PathParam.class);
                        HeaderParam headerParam = param.getAnnotation(HeaderParam.class);
                        FormParam formParam = param.getAnnotation(FormParam.class);
                        QueryParam queryParam = param.getAnnotation(QueryParam.class);
                        try {
                            String[] valuesStr;
                            String valueStr;
                            if (pathParam != null) {
                                valueStr = matcher.group(pathParam.value());
                                if (valueStr == null) {
                                    valueStr = this.getParamDefaultValue(param);
                                }
                                if (valueStr != null) {
                                    value = JaxRsRequestHandler.convertToValue(param.getType(), valueStr);
                                }
                                break block49;
                            }
                            if (headerParam != null) {
                                valueStr = request.getHeader(headerParam.value());
                                if (valueStr == null) {
                                    valueStr = this.getParamDefaultValue(param);
                                }
                                if (valueStr != null) {
                                    value = JaxRsRequestHandler.convertToValue(param.getType(), valueStr);
                                }
                                break block49;
                            }
                            if (formParam != null) {
                                String defValue;
                                valuesStr = request.getParameterValues(formParam.value());
                                if (valuesStr == null && (defValue = this.getParamDefaultValue(param)) != null) {
                                    valuesStr = new String[]{this.getParamDefaultValue(param)};
                                }
                                if (Boolean.TYPE.equals(param.getType())) {
                                    value = valuesStr != null && valuesStr.length == 1 && "on".equals(valuesStr[0]);
                                } else if (valuesStr != null) {
                                    value = JaxRsRequestHandler.convertToValue(param.getParameterizedType(), valuesStr);
                                }
                                break block49;
                            }
                            if (queryParam != null) {
                                valuesStr = request.getParameterValues(queryParam.value());
                                if (valuesStr == null) {
                                    valuesStr = new String[]{this.getParamDefaultValue(param)};
                                }
                                if (Boolean.TYPE.equals(param.getType())) {
                                    value = valuesStr != null && valuesStr.length == 1 && "on".equals(valuesStr[0]);
                                } else if (valuesStr != null) {
                                    value = JaxRsRequestHandler.convertToValue(param.getParameterizedType(), valuesStr);
                                }
                                break block49;
                            }
                            if (param.getAnnotation(Suspended.class) != null) {
                                if (asyncResponse == null) {
                                    asyncResponse = new AsyncResponseImpl(this, executorService, request, acceptedType);
                                }
                                value = asyncResponse;
                                break block49;
                            }
                            if (param.getAnnotation(BeanParam.class) != null) {
                                try {
                                    value = new WWWFormUrlEncodedUnmarshaller().unmarshal(param.getType(), request);
                                    break block49;
                                }
                                catch (UnmarshalException ex) {
                                    throw new HttpException(ex, 406);
                                }
                            }
                            if (Pageable.class.isAssignableFrom(param.getType())) {
                                value = Pageable.from(request);
                            } else if (SecurityContext.class.isAssignableFrom(param.getType())) {
                                value = context.getSecurityContext();
                            } else if (HttpServletRequest.class.isAssignableFrom(param.getType())) {
                                value = context.getRequest();
                            } else if (HttpServletResponse.class.isAssignableFrom(param.getType())) {
                                value = response;
                            } else if (UriInfo.class.isAssignableFrom(param.getType())) {
                                value = context.getUriInfo();
                            } else if (Model.class.isAssignableFrom(param.getType())) {
                                value = new Model(context);
                            } else {
                                String contentType = request.getContentType();
                                if (contentType != null) {
                                    value = this.decodeContent(param.getType(), request);
                                }
                            }
                        }
                        catch (ValidationException ex) {
                            log.log(Level.FINER, ex, () -> "failed to parse request parameter");
                            parsingExceptions.put(param, ex);
                        }
                    }
                    values.add(value);
                    ++n2;
                }
                try {
                    ContainerRequestContext.setContext(context);
                    this.validateParameters(this.handler, this.method, values.toArray(), parsingExceptions::containsKey, violations::add);
                    if (!violations.isEmpty() || !parsingExceptions.isEmpty()) {
                        this.throwValidationError(violations, parsingExceptions.values());
                    }
                    Object result = this.method.invoke((Object)this.handler, values.toArray());
                    if (Void.TYPE.equals(this.method.getReturnType())) {
                        return;
                    }
                    try {
                        if (result != null) {
                            this.sendEncodedContent(result, acceptedType, response);
                            break block50;
                        }
                        response.setStatus(200);
                    }
                    catch (IllegalAccessException | InvocationTargetException ex) {
                        this.unwrapInvocationTargetException(ex);
                    }
                }
                finally {
                    ContainerRequestContext.resetContext();
                }
            }
            catch (Throwable ex) {
                if (asyncResponse != null) {
                    asyncResponse.resume(ex);
                }
                log.log(Level.WARNING, "Exception while processing request", ex);
                throw ex;
            }
        }
    }

    private void unwrapInvocationTargetException(Throwable ex) throws HttpException {
        if (ex instanceof InvocationTargetException) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                this.unwrapInvocationTargetException(cause);
            }
        } else {
            if (ex instanceof HttpException) {
                throw (HttpException)((Object)ex.getCause());
            }
            if (ex instanceof TigaseStringprepException) {
                throw new ValidationException(ex.getMessage(), ex);
            }
            throw new HttpException(ex, 500);
        }
    }

    private void validateParameters(Object handler, Method method, Object[] values, Predicate<Parameter> skipValidation, Consumer<ConstraintViolation> consumer) throws HttpException {
        Parameter[] parameters = method.getParameters();
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = parameters[i];
            if (!skipValidation.test(parameter)) {
                Object value = values[i];
                this.validateValue(parameter, parameter.getType(), value, null, consumer);
            }
            ++i;
        }
    }

    private void validateValue(AnnotatedElement store, Class<?> type, Object value, ConstraintViolation.Path path, Consumer<ConstraintViolation> consumer) throws HttpException {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = store.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            List<Predicate<Object>> validators = this.getValidators(annotation);
            for (Predicate<Object> validator : validators) {
                if (validator.test(value)) continue;
                consumer.accept(this.createViolation(path, annotation, store, value));
            }
            if (annotation instanceof NotNull || type.isPrimitive()) {
                if (!Objects.nonNull(value)) {
                    consumer.accept(this.createViolation(path, annotation, store, value));
                }
            } else if (annotation instanceof NotEmpty) {
                if (String.class.isAssignableFrom(type) && (value == null || value.toString().isEmpty())) {
                    consumer.accept(this.createViolation(path, annotation, store, value));
                }
                if (Collection.class.isAssignableFrom(type) && (value == null || ((Collection)value).isEmpty())) {
                    consumer.accept(this.createViolation(path, annotation, store, value));
                }
            } else if (annotation instanceof NotBlank) {
                if (String.class.isAssignableFrom(type) && (value == null || value.toString().isBlank())) {
                    consumer.accept(this.createViolation(path, annotation, store, value));
                }
            } else if (annotation instanceof Pattern) {
                if (value == null || !java.util.regex.Pattern.matches(((Pattern)annotation).regexp(), value.toString())) {
                    consumer.accept(this.createViolation(path, annotation, store, value));
                }
            } else if ((annotation instanceof Valid || path != null) && value != null) {
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    ArrayList items = new ArrayList(collection);
                    int i = 0;
                    while (i < items.size()) {
                        Object item = items.get(i);
                        if (item != null) {
                            ConstraintViolation.Path itemPath = (path == null ? ConstraintViolation.Path.ROOT : path).appendItem(i);
                            try {
                                Field[] fieldArray = value.getClass().getDeclaredFields();
                                int n3 = fieldArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Field field = fieldArray[n4];
                                    field.setAccessible(true);
                                    this.validateValue(field, field.getType(), field.get(item), itemPath.appendField(field.getName()), consumer);
                                    ++n4;
                                }
                            }
                            catch (IllegalAccessException ex) {
                                throw new HttpException(ex, 500);
                            }
                        }
                        ++i;
                    }
                } else {
                    try {
                        Field[] fieldArray = value.getClass().getDeclaredFields();
                        int n5 = fieldArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Field field = fieldArray[n6];
                            field.setAccessible(true);
                            this.validateValue(field, field.getType(), field.get(value), (path == null ? ConstraintViolation.Path.ROOT : path).appendField(field.getName()), consumer);
                            ++n6;
                        }
                    }
                    catch (IllegalAccessException ex) {
                        throw new HttpException(ex, 500);
                    }
                }
            }
            ++n2;
        }
    }

    private ConstraintViolation createViolation(ConstraintViolation.Path path, Annotation annotation, AnnotatedElement store, Object value) {
        String message;
        block19: {
            block18: {
                message = null;
                try {
                    message = annotation.annotationType().getDeclaredMethod("message", new Class[0]).invoke((Object)annotation, new Object[0]).toString();
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    message = null;
                }
                if (message != null) break block18;
                message = annotation.annotationType().getName();
                break block19;
            }
            message = switch (message) {
                case "{javax.validation.constraints.NotNull.message}" -> "may not be null";
                case "{javax.validation.constraints.NotEmpty.message}" -> "may not be empty";
                case "{javax.validation.constraints.NotBlank.message}" -> "may not be blank";
                case "{javax.validation.constraints.Pattern.message}" -> "must match pattern '" + ((Pattern)annotation).regexp() + "'";
                default -> message;
            };
        }
        return new ConstraintViolation(message, path, store, value, store instanceof Parameter ? this.getParameterNameDescription((Parameter)store) : null);
    }

    private List<Predicate<Object>> getValidators(Annotation annotation) {
        return this.getAnnotationValidators(annotation).map(validatorClass -> {
            try {
                return (ConstraintValidator)validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new HttpException(ex, 500);
            }
        }).map(validator -> new Predicate<Object>(){

            @Override
            public boolean test(Object it) {
                return validator.isValid(it, null);
            }
        }).toList();
    }

    private <A extends Annotation> Stream<Class<? extends ConstraintValidator<A, Object>>> getAnnotationValidators(A annotation) {
        Class[] validatorClasses;
        Constraint constraint = annotation.annotationType().getAnnotation(Constraint.class);
        if (constraint != null && (validatorClasses = constraint.validatedBy()).length > 0) {
            return Stream.of(validatorClasses);
        }
        return Stream.empty();
    }

    private void throwValidationError(Collection<ConstraintViolation> violations, Collection<ValidationException> parsingExceptions) {
        if (violations.isEmpty() && parsingExceptions.isEmpty()) {
            return;
        }
        throw new ExtendedValidationException(violations, parsingExceptions);
    }

    private String getParamDefaultValue(Parameter param) {
        DefaultValue defValue = param.getAnnotation(DefaultValue.class);
        if (defValue == null) {
            return null;
        }
        return defValue.value();
    }

    public static Object convertToValue(Type expectedType, String[] valueStrs) {
        if (expectedType instanceof ParameterizedType) {
            Type[] params = ((ParameterizedType)expectedType).getActualTypeArguments();
            if (params == null || params.length != 1 || !(params[0] instanceof Class)) {
                return null;
            }
            return JaxRsRequestHandler.convertToValue((Class)((ParameterizedType)expectedType).getRawType(), (Class)params[0], valueStrs);
        }
        return JaxRsRequestHandler.convertToValue((Class)expectedType, null, valueStrs);
    }

    public static Object convertToValue(Class<?> expectedClass, Class<?> parameterClass, String[] valueStrs) {
        if (Collection.class.isAssignableFrom(expectedClass)) {
            if (parameterClass == null) {
                return null;
            }
            Stream<Object> stream = Arrays.stream(valueStrs).map(str -> JaxRsRequestHandler.convertToValue(parameterClass, str));
            if (List.class.isAssignableFrom(expectedClass)) {
                return stream.collect(Collectors.toUnmodifiableList());
            }
            if (Set.class.isAssignableFrom(expectedClass)) {
                return stream.collect(Collectors.toUnmodifiableSet());
            }
            if (SortedSet.class.isAssignableFrom(expectedClass)) {
                return Collections.unmodifiableSortedSet(new TreeSet(stream.collect(Collectors.toList())));
            }
            return null;
        }
        if (valueStrs.length != 1) {
            return null;
        }
        return JaxRsRequestHandler.convertToValue(expectedClass, valueStrs[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object convertToValue(Class expectedClass, String valueStr) {
        Function<String, Object> mapper = DESERIALIZERS.get(expectedClass);
        if (mapper != null) return mapper.apply(valueStr);
        try {
            Method method = expectedClass.getDeclaredMethod("fromString", String.class);
            return method.invoke(null, valueStr);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            try {
                Method method = expectedClass.getDeclaredMethod("valueOf", String.class);
                return method.invoke(null, valueStr);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                if (valueStr != null && valueStr.isEmpty()) {
                    return null;
                }
                try {
                    throw new ValidationException("Value '" + valueStr + "' cannot be converted to " + expectedClass.getCanonicalName(), (Throwable)ex);
                }
                catch (Throwable ex2) {
                    throw new ValidationException("Value '" + valueStr + "' cannot be converted to " + expectedClass.getCanonicalName(), ex2);
                }
            }
        }
    }

    private Object decodeContent(Class clazz, HttpServletRequest request) throws HttpException, IOException {
        Unmarshaller unmarshaller = this.newUnmarshaller(request.getContentType());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ServletInputStream inputStream = request.getInputStream();){
                return unmarshaller.unmarshal(clazz, (InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnmarshalException e) {
            throw new HttpException(e, 422);
        }
    }

    public void sendEncodedContent(Object object, Optional<String> acceptedType, HttpServletResponse response) throws HttpException, IOException {
        try {
            if (object instanceof Response) {
                Response resp = (Response)object;
                for (Map.Entry entry : resp.getStringHeaders().entrySet()) {
                    for (String it : (List)entry.getValue()) {
                        response.addHeader((String)entry.getKey(), it);
                    }
                }
                Object entity = resp.getEntity();
                if (entity != null && entity instanceof byte[]) {
                    response.setContentLength(((byte[])entity).length);
                }
                Response.StatusType status = resp.getStatusInfo();
                response.setStatus(status.getStatusCode());
                if (entity != null) {
                    if (entity instanceof byte[]) {
                        response.getOutputStream().write((byte[])entity);
                    } else if (entity instanceof String) {
                        response.getWriter().write((String)entity);
                    } else {
                        this.encodeObject(object, acceptedType.orElse("application/xml"), response);
                    }
                } else if (status.getReasonPhrase() != null) {
                    response.getWriter().write(status.getReasonPhrase());
                }
            } else {
                this.encodeObject(object, acceptedType.orElse("application/xml"), response);
            }
        }
        catch (MarshalException e) {
            throw new HttpException(e, 500);
        }
    }

    private void encodeObject(Object object, String mimeType, HttpServletResponse response) throws UnsupportedFormatException, MarshalException, IOException {
        Marshaller marshaller = this.newMarshaller(mimeType);
        response.setContentType(mimeType);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ServletOutputStream outputStream = response.getOutputStream();){
            marshaller.marshall(object, (OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Marshaller newMarshaller(String acceptedType) throws UnsupportedFormatException {
        return switch (acceptedType) {
            case "application/json" -> new JsonMarshaller();
            case "application/xml" -> new XmlMarshaller();
            default -> throw new UnsupportedFormatException("Format '" + acceptedType + "' is not supported!");
        };
    }

    protected Optional<String> selectResponseMimeType(Method method, HttpServletRequest request) throws HttpException {
        if (this.producedContentTypes.isEmpty()) {
            return Optional.empty();
        }
        String header = request.getHeader("Accept");
        if (header == null) {
            return Optional.empty();
        }
        return Arrays.stream(header.split(",")).map(AcceptedType::new).filter(it -> this.producedContentTypes.contains(it.getMimeType())).sorted(Comparator.comparing(AcceptedType::getPreference).reversed()).findFirst().map(AcceptedType::getMimeType);
    }

    private Unmarshaller newUnmarshaller(String contentType) throws UnsupportedFormatException {
        return switch (contentType) {
            case "application/json" -> new JsonUnmarshaller();
            case "application/xml" -> new XmlUnmarshaller();
            default -> throw new UnsupportedFormatException("Format '" + contentType + "' is not supported!");
        };
    }

    @Override
    public int compareTo(RequestHandler rh) {
        if (rh instanceof JaxRsRequestHandler) {
            JaxRsRequestHandler o = (JaxRsRequestHandler)rh;
            int r = PATTERN_COMPARATOR.compare(this.pattern, o.pattern);
            if (r != 0) {
                return r;
            }
            r = o.consumedContentTypes.size() - this.consumedContentTypes.size();
            if (r != 0) {
                return r;
            }
            r = o.producedContentTypes.size() - this.producedContentTypes.size();
            return r;
        }
        return Integer.MAX_VALUE;
    }

    private static class Param {
        private final String name;
        private final String regex;
        private final int startIdx;
        private final int endIdx;

        private Param(String name, String regex, int startIdx, int endIdx) {
            this.name = name;
            this.regex = regex;
            this.startIdx = startIdx;
            this.endIdx = endIdx;
        }
    }
}

