/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import jakarta.annotation.security.RolesAllowed;
import java.lang.reflect.Method;
import java.util.Set;

public interface Handler {
    public static Set<String> getAllowedRoles(Method method) {
        Set<String> allowedRoles = Handler.getAllowedRoles(method.getAnnotation(RolesAllowed.class));
        if (allowedRoles != null) {
            return allowedRoles;
        }
        return Handler.getAllowedRoles(method.getDeclaringClass().getAnnotation(RolesAllowed.class));
    }

    public static Set<String> getAllowedRoles(RolesAllowed annotation) {
        if (annotation == null) {
            return null;
        }
        return Set.of(annotation.value());
    }

    public Role getRequiredRole();

    public static enum Role {
        None,
        User,
        Admin;


        public boolean isAuthenticationRequired() {
            return this != None;
        }
    }
}

