/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java.filters;

import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.http.AbstractHttpServer;
import tigase.net.SocketType;

public class ProtocolRedirectFilter
implements Filter {
    private static final Logger log = Logger.getLogger(ProtocolRedirectFilter.class.getCanonicalName());
    private String serverBeanName;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.serverBeanName = filterConfig.getInitParameter("serverBeanName");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            Optional<AbstractHttpServer.PortConfigBean> portConfigBean = AbstractHttpServer.getPortConfig(this.serverBeanName, request.getLocalPort());
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "X-Forwarded-Proto: " + request.getHeader("X-Forwarded-Proto") + ", request protocol: " + request.getProtocol() + ", socket protocol: " + String.valueOf(portConfigBean.map(AbstractHttpServer.PortConfigBean::getSocket)) + ", redirect URL: " + String.valueOf(portConfigBean.map(AbstractHttpServer.PortConfigBean::getRedirectUri)) + ", condition: " + String.valueOf(portConfigBean.map(AbstractHttpServer.PortConfigBean::getRedirectCondition)));
            }
            if (portConfigBean.isPresent() && this.shouldRedirect(request, portConfigBean.get())) {
                this.sendRedirect(request, response, portConfigBean.get());
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    protected boolean shouldRedirect(HttpServletRequest request, AbstractHttpServer.PortConfigBean configBean) {
        if (configBean.getRedirectUri() == null) {
            return false;
        }
        switch (configBean.getRedirectCondition()) {
            case never: {
                return false;
            }
            case always: {
                return true;
            }
            case http: {
                return this.protocolMatches("http", request, configBean);
            }
            case https: {
                return this.protocolMatches("https", request, configBean);
            }
        }
        throw new IllegalArgumentException("Unsupported redirect condition = " + String.valueOf((Object)configBean.getRedirectCondition()));
    }

    private boolean protocolMatches(String expectedProtocol, HttpServletRequest request, AbstractHttpServer.PortConfigBean configBean) {
        String forwardedProtocol = request.getHeader("X-Forwarded-Proto");
        if (forwardedProtocol != null) {
            return expectedProtocol.matches(forwardedProtocol);
        }
        return this.redirectionConditionSatisfied(configBean);
    }

    protected boolean redirectionConditionSatisfied(AbstractHttpServer.PortConfigBean configBean) {
        switch (configBean.getRedirectCondition()) {
            case http: {
                return configBean.getSocket() == SocketType.plain;
            }
            case https: {
                return configBean.getSocket() != SocketType.plain;
            }
        }
        throw new IllegalArgumentException("Unsupported redirect condition = " + String.valueOf((Object)configBean.getRedirectCondition()));
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, AbstractHttpServer.PortConfigBean configBean) throws IOException {
        String originalRequestHost = Optional.ofNullable(request.getHeader("Host")).map(this::parseHostname).orElse("localhost");
        String requestQuery = Optional.ofNullable(request.getQueryString()).map(query -> "?" + query).orElse("");
        String uri = configBean.getRedirectUri().replace("{host}", originalRequestHost) + request.getRequestURI() + requestQuery;
        response.sendRedirect(uri);
    }

    private String parseHostname(String host) {
        int idx = host.indexOf(":");
        return idx >= 0 ? host.substring(0, idx) : host;
    }
}

