/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.servlet.ServletException;
import tigase.annotations.TigaseDeprecated;
import tigase.cluster.ClusterConnectionManager;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.http.AbstractHttpServer;
import tigase.http.DeploymentInfo;
import tigase.http.java.RequestHandler;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.beans.selector.ServerBeanSelector;
import tigase.kernel.core.Kernel;
import tigase.net.SocketType;

@TigaseDeprecated(removeIn="9.0.0", since="8.5.0", note="JavaStandaloneHttpServer will be removed and should be replaced by JettyStandaloneHttpServer")
@Deprecated
@Bean(name="httpServer", active=false, exportable=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SetupMode})
public class JavaStandaloneHttpServer
extends AbstractHttpServer {
    private static final Logger log = Logger.getLogger(JavaStandaloneHttpServer.class.getCanonicalName());
    private final Set<HttpServer> servers = new HashSet<HttpServer>();
    private List<DeploymentInfo> deployments = new ArrayList<DeploymentInfo>();
    @Inject
    private ExecutorWithTimeout executor;
    private boolean delayStartup = false;

    @Override
    public void initialize() {
        log.log(Level.WARNING, "JavaStandaloneHttpServer was deprecated and will be removed in Tigase XMPP Server version 9.0.0. Please migrate to our new 'JettyStandaloneHttpServer'");
        super.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(DeploymentInfo deployment) {
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            this.deployments.add(deployment);
            this.servers.forEach(server -> this.deploy((HttpServer)server, deployment));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(DeploymentInfo deployment) {
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            this.servers.forEach(server -> this.undeploy((HttpServer)server, deployment));
            this.deployments.remove(deployment);
        }
    }

    @Override
    public List<DeploymentInfo> listDeployed() {
        return Collections.unmodifiableList(this.deployments);
    }

    @Override
    public void register(Kernel kernel) {
        this.delayStartup = ServerBeanSelector.getClusterMode((Kernel)kernel) && ServerBeanSelector.getConfigType((Kernel)kernel) != ConfigTypeEnum.SetupMode;
        super.register(kernel);
    }

    protected HttpServer createServer(PortConfigBean config) throws IOException {
        if (config.getSocket() == SocketType.plain) {
            return HttpServer.create(new InetSocketAddress(config.getPort()), 100);
        }
        HttpsServer server = HttpsServer.create(new InetSocketAddress(config.getPort()), 100);
        SSLContext sslContext = this.sslContextContainer.getSSLContext("TLS", config.getDomain(), false);
        server.setHttpsConfigurator(new HttpsConfigurator(sslContext){

            @Override
            public void configure(HttpsParameters httpsParameters) {
                super.configure(httpsParameters);
                SSLParameters sslParameters = this.getSSLContext().getDefaultSSLParameters();
                sslParameters.setSNIMatchers(Collections.singleton(new SNIMatcher(0){

                    @Override
                    public boolean matches(SNIServerName sniServerName) {
                        return true;
                    }
                }));
                httpsParameters.setSSLParameters(sslParameters);
            }
        });
        return server;
    }

    protected void deploy(HttpServer server) {
        Collections.unmodifiableList(this.deployments).forEach(info -> this.deploy(server, (DeploymentInfo)info));
    }

    protected void deploy(HttpServer server, DeploymentInfo info) {
        try {
            server.createContext(info.getContextPath(), new RequestHandler(this, info, this.executor.timer));
        }
        catch (ServletException ex) {
            String message = "Could not deploy " + info.getContextPath() + " at " + this.getName() + " at port " + server.getAddress().getPort();
            log.log(Level.WARNING, message);
            throw new RuntimeException(ex);
        }
    }

    protected void undeploy(HttpServer server) {
        Collections.unmodifiableList(this.deployments).forEach(info -> this.undeploy(server, (DeploymentInfo)info));
    }

    protected void undeploy(HttpServer server, DeploymentInfo info) {
        try {
            server.removeContext(info.getContextPath());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.log(Level.FINEST, "deployment context " + info.getContextPath() + " already removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerServer(HttpServer server) {
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            this.servers.add(server);
            int port = server.getAddress().getPort();
            if (server instanceof HttpsServer) {
                this.httpsPorts.add(port);
            } else {
                this.httpPorts.add(port);
            }
            this.deploy(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterServer(HttpServer server) {
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            this.undeploy(server);
            int port = server.getAddress().getPort();
            if (server instanceof HttpsServer) {
                this.httpsPorts.remove((Object)port);
            } else {
                this.httpPorts.remove((Object)port);
            }
            server.getAddress().getPort();
            this.servers.remove(server);
        }
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    static /* synthetic */ void access$1(JavaStandaloneHttpServer javaStandaloneHttpServer, boolean bl) {
        javaStandaloneHttpServer.delayStartup = bl;
    }

    @Bean(name="executor", parent=JavaStandaloneHttpServer.class, active=true, exportable=true)
    public static class ExecutorWithTimeout
    implements Executor,
    Initializable,
    UnregisterAware,
    ConfigurationChangedAware {
        private static final String THREADS_KEY = "threads";
        private static final String REQUEST_TIMEOUT_KEY = "request-timeout";
        private AtomicInteger counter = new AtomicInteger(0);
        private ExecutorService executor = null;
        @ConfigField(desc="Number of threads", alias="threads")
        private int threads = 4;
        @ConfigField(desc="Request timeout", alias="request-timeout")
        private int timeout = 60000;
        @ConfigField(desc="Accept timeout", alias="accept-timeout")
        private int acceptTimeout = 2000;
        private Timer timer;

        @Override
        public void execute(Runnable command) {
            this.executor.execute(() -> {
                RequestHandler.setRequestId();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "executing for:" + String.valueOf(RequestHandler.getRequestId()) + " - " + command.toString());
                }
                this.timer.connectionAccepted();
                command.run();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "execution completed for:" + String.valueOf(RequestHandler.getRequestId()) + " - " + command.toString());
                }
                this.timer.requestProcessingFinished();
            });
        }

        public void beforeUnregister() {
            this.executor.shutdown();
            this.timer.shutdown();
        }

        public void initialize() {
            if (this.executor != null) {
                this.beforeUnregister();
            }
            this.executor = Executors.newFixedThreadPool(this.threads, r -> {
                Thread t = new Thread(r);
                t.setName("http-server-pool-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            });
            this.timer = new Timer(this::getAcceptTimeout, this::getTimeout);
        }

        public void beanConfigurationChanged(Collection<String> changedFields) {
            this.initialize();
        }

        public int getAcceptTimeout() {
            return this.acceptTimeout;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public static class Timer {
            private ThreadLocal<ScheduledFuture> threadTimeouts = new ThreadLocal();
            private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            private final Supplier<Integer> acceptTimeoutSupplier;
            public final Supplier<Integer> requestTimeoutSupplier;

            private Timer(Supplier<Integer> acceptTimeoutSupplier, Supplier<Integer> requestTimeoutSupplier) {
                this.acceptTimeoutSupplier = acceptTimeoutSupplier;
                this.requestTimeoutSupplier = requestTimeoutSupplier;
            }

            private void shutdown() {
                this.executor.shutdown();
            }

            public void connectionAccepted() {
                Thread currentThread = Thread.currentThread();
                int reqId = RequestHandler.getRequestId();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "request accept timer started: " + reqId);
                }
                this.threadTimeouts.set(this.executor.schedule(() -> {
                    log.log(Level.WARNING, "request accept time exceeded! for id = " + reqId);
                    currentThread.interrupt();
                }, (long)this.acceptTimeoutSupplier.get().intValue(), TimeUnit.MILLISECONDS));
            }

            public void requestProcessingStarted() {
                ScheduledFuture timeout = this.threadTimeouts.get();
                if (timeout != null) {
                    int reqId = RequestHandler.getRequestId();
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "request accept timer ended: " + reqId);
                    }
                    timeout.cancel(false);
                }
                Thread currentThread = Thread.currentThread();
                int reqId = RequestHandler.getRequestId();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "request processing timer started: " + reqId);
                }
                this.threadTimeouts.set(this.executor.schedule(() -> {
                    log.log(Level.WARNING, "request processing time exceeded! for id = " + reqId);
                    currentThread.interrupt();
                }, (long)this.requestTimeoutSupplier.get().intValue(), TimeUnit.MILLISECONDS));
            }

            public void requestProcessingFinished() {
                ScheduledFuture timeout = this.threadTimeouts.get();
                if (timeout != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "request accept/processing timer ended: " + String.valueOf(RequestHandler.getRequestId()));
                    }
                    timeout.cancel(false);
                }
            }

            public ScheduledExecutorService getScheduledExecutorService() {
                return this.executor;
            }
        }
    }

    public static class PortConfigBean
    extends AbstractHttpServer.PortConfigBean {
        protected HttpServer httpServer;
        private final EventBus eventBus = EventBusFactory.getInstance();
        @Inject(bean="executor")
        private ExecutorWithTimeout executor;
        @Inject
        private JavaStandaloneHttpServer serverManager;
        private ScheduledFuture startupFuture;

        public void beanConfigurationChanged(Collection<String> changedFields) {
            if (this.serverManager == null) {
                return;
            }
            this.beforeUnregister();
            this.initialize();
        }

        public void beforeUnregister() {
            this.startupFuture.cancel(true);
            this.eventBus.unregisterAll((Object)this);
            if (this.httpServer != null) {
                this.serverManager.unregisterServer(this.httpServer);
                this.httpServer.stop(1);
                this.httpServer = null;
            }
        }

        public void initialize() {
            this.eventBus.registerAll((Object)this);
            this.startServers();
        }

        @HandleEvent
        public void serverInitialized(ClusterConnectionManager.ClusterInitializedEvent event) {
            if (this.serverManager != null) {
                this.serverManager.delayStartup = false;
            }
            this.startServers();
        }

        protected void startServers() {
            if (this.httpServer == null) {
                if (!this.serverManager.delayStartup) {
                    log.log(Level.INFO, () -> "Starting listening on port " + this.getPort() + " of HTTP server");
                    try {
                        this.httpServer = this.serverManager.createServer(this);
                        this.httpServer.setExecutor(this.executor);
                        this.httpServer.start();
                        this.serverManager.registerServer(this.httpServer);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Could not initialize HTTP server for port " + this.getPort());
                    }
                } else {
                    log.log(Level.INFO, () -> "Delaying opening of port " + this.getPort() + " of HTTP server");
                    this.startupFuture = this.executor.timer.executor.schedule(() -> {
                        if (this.serverManager != null) {
                            this.serverManager.delayStartup = false;
                        }
                        this.startServers();
                    }, 30L, TimeUnit.SECONDS);
                }
            }
        }
    }

    @Bean(name="connections", parent=JavaStandaloneHttpServer.class, active=true, exportable=true)
    public static class PortsConfigBean
    extends AbstractHttpServer.PortsConfigBean {
        public Class<?> getDefaultBeanClass() {
            return PortConfigBean.class;
        }
    }

    private static class RedirectHandler
    implements HttpHandler {
        private final String redirectEndpoint;

        public RedirectHandler(String redirectEndpoint) {
            this.redirectEndpoint = redirectEndpoint;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String originalRequestHost = Optional.ofNullable(exchange.getRequestHeaders().getFirst("Host")).map(this::parseHostname).orElse("localhost");
            String requestEndpoint = this.redirectEndpoint.replace("{host}", originalRequestHost);
            String requestPath = Optional.ofNullable(exchange.getRequestURI().getRawPath()).orElse("/");
            String requestQuery = Optional.ofNullable(exchange.getRequestURI().getRawQuery()).map(query -> "?" + query).orElse("");
            String uri = requestEndpoint + requestPath + requestQuery;
            exchange.getResponseHeaders().set("Location", uri);
            exchange.sendResponseHeaders(301, -1L);
        }

        private String parseHostname(String host) {
            int idx = host.indexOf(":");
            return idx >= 0 ? host.substring(0, idx) : host;
        }
    }
}

