/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import tigase.http.api.HttpServerIfc;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.core.Kernel;

public abstract class AbstractHttpModule
implements UnregisterAware,
Initializable,
RegistrarBean,
ConfigurationChangedAware {
    private static final Map<String, Kernel> kernels = new ConcurrentHashMap<String, Kernel>();
    protected final String uuid = UUID.randomUUID().toString();
    @ConfigField(desc="Context path", alias="context-path")
    protected String contextPath = null;
    @Inject
    protected HttpServerIfc httpServer;
    @ConfigField(desc="List of vhosts", alias="vhosts")
    protected String[] vhosts = null;

    public static final Kernel getKernel(String id) {
        return kernels.get(id);
    }

    public abstract void start();

    public abstract void stop();

    public void register(Kernel kernel) {
        kernels.put(this.uuid, kernel);
    }

    public void unregister(Kernel kernel) {
        kernels.remove(this.uuid);
    }

    public void initialize() {
        this.start();
    }

    public void beforeUnregister() {
        this.stop();
    }

    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (this.httpServer == null) {
            return;
        }
        this.start();
    }
}

