/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.api.marshallers;

import jakarta.xml.bind.MarshalException;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.junit.jupiter.api.Test;
import tigase.http.api.marshallers.AbstractMarshallerTest;
import tigase.http.api.marshallers.TestObject;
import tigase.http.jaxrs.marshallers.Marshaller;
import tigase.http.jaxrs.marshallers.XmlMarshaller;

class XmlMarshallerTest
extends AbstractMarshallerTest {
    XmlMarshallerTest() {
    }

    @Test
    public void test1() throws MarshalException, IOException {
        TestObject data = new TestObject("root");
        data.getItems().add(new TestObject("item 1"));
        data.getItems().add(new TestObject("item 2"));
        String expected = "<TestObject data=\"" + String.valueOf(data.getData()) + "\"><title>root</title><date>" + ZonedDateTime.ofInstant(data.getDate().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "</date><items data=\"" + String.valueOf(data.getData()) + "\"><title>item 1</title><date>" + ZonedDateTime.ofInstant(data.getItems().get(0).getDate().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "</date></items><items data=\"" + String.valueOf(data.getData()) + "\"><title>item 2</title><date>" + ZonedDateTime.ofInstant(data.getItems().get(1).getDate().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "</date></items></TestObject>";
        this.assertMarshalling(expected, data);
    }

    @Override
    Marshaller createMarshaller() {
        return new XmlMarshaller();
    }
}

