/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.api.marshallers;

import jakarta.xml.bind.MarshalException;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.junit.jupiter.api.Test;
import tigase.http.api.marshallers.AbstractMarshallerTest;
import tigase.http.api.marshallers.TestObject;
import tigase.http.jaxrs.marshallers.JsonMarshaller;
import tigase.http.jaxrs.marshallers.Marshaller;

class JsonMarshallerTest
extends AbstractMarshallerTest {
    JsonMarshallerTest() {
    }

    @Test
    public void test1() throws MarshalException, IOException {
        TestObject data = new TestObject("root");
        data.getItems().add(new TestObject("item 1"));
        data.getItems().add(new TestObject("item 2"));
        String expected = "{\"title\":\"root\",\"data\":\"" + String.valueOf(data.getData()) + "\",\"date\":\"" + ZonedDateTime.ofInstant(data.getDate().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "\",\"items\":[{\"title\":\"item 1\",\"data\":\"" + String.valueOf(data.getData()) + "\",\"date\":\"" + ZonedDateTime.ofInstant(data.getItems().get(0).getDate().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "\",\"items\":[]},{\"title\":\"item 2\",\"data\":\"" + String.valueOf(data.getData()) + "\",\"date\":\"" + ZonedDateTime.ofInstant(data.getItems().get(1).getDate().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "\",\"items\":[]}]}";
        this.assertMarshalling(expected, data);
    }

    @Override
    Marshaller createMarshaller() {
        return new JsonMarshaller();
    }
}

