/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload.commands;

import java.util.Optional;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.db.TigaseDBException;
import tigase.http.upload.FileUploadComponent;
import tigase.http.upload.db.FileUploadRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="query-space-used-command-domain", parent=FileUploadComponent.class, active=true)
public class QueryUsedSpaceCommandDomain
implements AdHocCommand {
    @Inject
    private FileUploadRepository repository;
    @Inject
    private AdHocCommandModule.ScriptCommandProcessor scriptCommandProcessor;

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        if (request.isAction("cancel")) {
            response.cancelSession();
            return;
        }
        try {
            Optional<String> domain = Optional.ofNullable(Command.getFieldValue((Packet)request.getIq(), (String)"domain"));
            if (domain.isEmpty()) {
                DataForm.Builder formBuilder = new DataForm.Builder(Command.DataType.form).withField(DataForm.FieldType.TextSingle, "domain", field -> {
                    DataForm.Field.Builder builder = field.setLabel("Domain");
                });
                response.getElements().add(formBuilder.build());
                response.setNewState(AdHocResponse.State.executing);
            } else {
                if (!this.scriptCommandProcessor.isAllowed(this.getNode(), domain.get(), request.getSender())) {
                    throw new AdHocCommandException(Authorization.FORBIDDEN);
                }
                long usedSpace = this.repository.getUsedSpaceForDomain(domain.get());
                DataForm.Builder formBuilder = new DataForm.Builder(Command.DataType.result).withField(DataForm.FieldType.TextSingle, "used-space", field -> {
                    DataForm.Field.Builder builder = field.setLabel("Used space").setValue(String.valueOf(usedSpace));
                });
                response.getElements().add(formBuilder.build());
                response.completeSession();
            }
        }
        catch (TigaseDBException tigaseDBException) {
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR);
        }
    }

    public String getName() {
        return "Query space used by uploaded files in domain";
    }

    public String getNode() {
        return "query-space-used-domain";
    }

    public boolean isAllowedFor(JID jid) {
        return this.scriptCommandProcessor.isAllowed(this.getNode(), jid);
    }
}

