/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload.commands;

import java.io.IOException;
import java.util.Optional;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.http.upload.db.FileUploadRepository;
import tigase.http.upload.store.Store;
import tigase.kernel.beans.Inject;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class DeleteFileCommandAbstract
implements AdHocCommand {
    @Inject
    private FileUploadRepository repository;
    @Inject
    private Store store;
    @Inject
    private AdHocCommandModule.ScriptCommandProcessor scriptCommandProcessor;
    private final boolean isAdmin;

    protected DeleteFileCommandAbstract(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        Optional<BareJID> user;
        if (request.isAction("cancel")) {
            response.cancelSession();
            return;
        }
        Optional<String> slotId = Optional.ofNullable(Command.getFieldValue((Packet)request.getIq(), (String)"slot-id"));
        Optional<BareJID> optional = user = this.isAdmin ? Optional.ofNullable(Command.getFieldValue((Packet)request.getIq(), (String)"jid")).map(BareJID::bareJIDInstanceNS) : Optional.of(request.getSender().getBareJID());
        if (slotId.isEmpty() || user.isEmpty()) {
            DataForm.Builder builder = new DataForm.Builder(Command.DataType.form).addInstructions(new String[]{"Please fill the form"});
            if (this.isAdmin) {
                builder.withField(DataForm.FieldType.JidSingle, "jid", field -> {
                    DataForm.Field.Builder builder = field.setLabel("JID").setValue((String)user.map(BareJID::toString).orElse(null));
                });
            }
            builder.withField(DataForm.FieldType.TextSingle, "slot-id", field -> {
                DataForm.Field.Builder builder = field.setLabel("Slot ID").setValue((String)slotId.orElse(null));
            });
            response.getElements().add(builder.build());
            response.setNewState(AdHocResponse.State.executing);
        } else {
            try {
                Optional<FileUploadRepository.Slot> slot = Optional.ofNullable(this.repository.getSlot(user.get(), slotId.get()));
                if (slot.isEmpty()) {
                    throw new AdHocCommandException(Authorization.FORBIDDEN);
                }
                if (!request.getSender().getBareJID().equals((Object)user.get()) && !this.scriptCommandProcessor.isAllowed(this.getNode(), user.get().getDomain(), request.getSender())) {
                    throw new AdHocCommandException(Authorization.FORBIDDEN);
                }
                this.store.remove(user.get(), slotId.get());
                this.repository.removeSlot(user.get(), slotId.get());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new AdHocCommandException(Authorization.FEATURE_NOT_IMPLEMENTED);
            }
            catch (IOException | RepositoryException throwable) {
                throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR);
            }
        }
    }

    public boolean isAllowedFor(JID jid) {
        return this.scriptCommandProcessor.isAllowed(this.getNode(), jid);
    }
}

