/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import gg.jte.TemplateOutput;
import gg.jte.output.StringOutput;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import tigase.db.util.SchemaLoader;
import tigase.db.util.SchemaManager;
import tigase.http.modules.setup.NextPage;
import tigase.http.modules.setup.SetupModule;
import tigase.http.modules.setup.pages.AbstractPage;
import tigase.http.modules.setup.pages.SetupSecurityPage;
import tigase.kernel.beans.Bean;

@Path(value="/databasePreparation")
@NextPage(value=SetupSecurityPage.class)
@Bean(name="databasePreparationPage", parent=SetupModule.class, active=true)
public class DatabasePreparationPage
extends AbstractPage {
    @Override
    public String getTitle() {
        return "Database preparation";
    }

    @GET
    public Response executeDbSchemaInstallation(HttpServletRequest request) {
        Map<SchemaManager.DataSourceInfo, List<SchemaManager.ResultEntry>> execResult = this.executeSchemaManager();
        StringOutput output = new StringOutput();
        Map<String, Object> context = this.prepareContext();
        List result = execResult.entrySet().stream().map(e -> new SchemaManager.Pair((Object)((SchemaManager.DataSourceInfo)e.getKey()), ((List)e.getValue()).stream().map(ResultEntry::new).collect(Collectors.toList()))).collect(Collectors.toList());
        context.put("result", result);
        this.engine.render("dbPrepare.jte", context, (TemplateOutput)output);
        return Response.ok((Object)output.toString(), (String)"text/html").build();
    }

    @POST
    public Response processForm(HttpServletRequest request) {
        return this.redirectToNext(request);
    }

    public Map<SchemaManager.DataSourceInfo, List<SchemaManager.ResultEntry>> executeSchemaManager() {
        Map<String, Object> config = this.getConfig().getAsMap();
        SchemaManager schemaManager = new SchemaManager();
        schemaManager.setConfig(config);
        if (this.getConfig().getDbConfig().hasDbRootCredentials()) {
            schemaManager.setDbRootCredentials(this.getConfig().getDbConfig().getDbRootName(), this.getConfig().getDbConfig().getDbRootPassword());
        }
        if (!this.getConfig().getAdmins().isEmpty()) {
            schemaManager.setAdmins(this.getConfig().getAdmins().stream().toList(), this.getConfig().getAdminPwd());
        }
        return schemaManager.loadSchemas();
    }

    public static class ResultEntry {
        private final SchemaManager.ResultEntry entry;

        public ResultEntry(SchemaManager.ResultEntry entry) {
            this.entry = entry;
        }

        public String getName() {
            return this.entry.name;
        }

        public String getResultName() {
            return this.entry.result.name();
        }

        public String getMessage() {
            return switch (this.entry.result) {
                case SchemaLoader.Result.ok -> null;
                default -> this.entry.message;
            };
        }

        public String getHeaderBackgroundClass() {
            return switch (this.entry.result) {
                case SchemaLoader.Result.ok -> "bg-success";
                case SchemaLoader.Result.skipped -> "bg-secondary";
                case SchemaLoader.Result.warning -> "bg-warning";
                case SchemaLoader.Result.error -> "bg-danger";
                default -> throw new MatchException(null, null);
            };
        }

        public String getResultTextClass() {
            return switch (this.entry.result) {
                case SchemaLoader.Result.ok -> "text-success";
                case SchemaLoader.Result.skipped -> "text-secondary";
                case SchemaLoader.Result.warning -> "text-warning";
                case SchemaLoader.Result.error -> "text-danger";
                default -> throw new MatchException(null, null);
            };
        }
    }
}

