/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest.users;

import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.http.api.rest.RestHandler;
import tigase.http.jaxrs.Handler;
import tigase.http.modules.rest.AbstractRestHandler;
import tigase.http.modules.rest.RestModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.util.Base64;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;

@Bean(name="avatarPut", parent=RestModule.class, active=false)
@Path(value="/avatar")
public class AvatarSetHandler
extends AbstractRestHandler {
    @Inject
    private UserRepository userRepository;

    public AvatarSetHandler() {
        super(RestHandler.Security.ApiKey, Handler.Role.None);
    }

    @PUT
    @Path(value="/{userJid}")
    public Response setAvatar(@NotNull @PathParam(value="userJid") BareJID user, @NotNull @HeaderParam(value="Content-Type") String contentType, byte[] data) throws TigaseDBException {
        String base64EncodedPhoto = Base64.encode((byte[])data);
        Element vCard = Optional.ofNullable(this.getVCard(user)).orElseGet(() -> this.createEmptyVCard());
        String mimeType = contentType.split(";")[0];
        Element photo = vCard.getChild("PHOTO");
        if (photo != null) {
            vCard.removeChild(photo);
        }
        photo = new Element("PHOTO").withElement("TYPE", null, mimeType).withElement("BINVAL", null, base64EncodedPhoto);
        vCard.addChild((XMLNodeIfc)photo);
        this.setVCard(user, vCard);
        return Response.ok().build();
    }

    private Element getVCard(BareJID user) throws TigaseDBException {
        String str = this.userRepository.getData(user, "public/vcard-temp", "vCard", null);
        if (str == null) {
            return null;
        }
        SimpleParser parser = SingletonFactory.getParserInstance();
        DomBuilderHandler domHandler = new DomBuilderHandler();
        char[] vCardData = str.toCharArray();
        parser.parse((SimpleHandler)domHandler, vCardData, 0, vCardData.length);
        return (Element)domHandler.getParsedElements().poll();
    }

    private void setVCard(BareJID user, Element vcard) throws TigaseDBException {
        this.userRepository.setData(user, "public/vcard-temp", "vCard", vcard.toString());
    }

    private Element createEmptyVCard() {
        return new Element("vCard").withAttribute("xmlns", "vcard-temp");
    }
}

