/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import jakarta.ws.rs.core.SecurityContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import tigase.http.jaxrs.SecurityContextHolder;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostManager;
import tigase.xmpp.jid.JID;

@Bean(name="permissionsHelper", parent=DashboardModule.class, active=true)
public class PermissionsHelper {
    @Inject
    private VHostManager vHostManager;
    @ConfigField(desc="User can create domain")
    private boolean userCanCreateDomain = false;

    public boolean canCreateDomain() {
        SecurityContext securityContext = SecurityContextHolder.getSecurityContext();
        if (securityContext == null) {
            return false;
        }
        if (securityContext.isUserInRole("admin")) {
            return true;
        }
        return securityContext.isUserInRole("user") && this.userCanCreateDomain;
    }

    public List<String> getManagedDomains(SecurityContext securityContext) {
        Stream<Object> domains = this.vHostManager.getAllVHosts().stream();
        if (!securityContext.isUserInRole("admin") && !securityContext.isUserInRole("account_manager")) {
            if (securityContext.isUserInRole("user")) {
                domains = domains.filter(domain -> this.canManageDomain(securityContext, domain.getDomain()));
            } else {
                return Collections.emptyList();
            }
        }
        return domains.map(JID::getDomain).filter(domain -> !"default".equals(domain)).sorted().toList();
    }

    public boolean canManageDomain(SecurityContext securityContext, String domain) {
        if (securityContext.isUserInRole("admin") || securityContext.isUserInRole("account_manager")) {
            return true;
        }
        VHostItem item = this.vHostManager.getVHostItem(domain);
        String user = securityContext.getUserPrincipal().getName();
        return item != null && (item.isAdmin(user) || item.isOwner(user));
    }
}

