/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.StringOutput;
import jakarta.ws.rs.core.SecurityContext;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.http.jaxrs.Handler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.http.util.TemplateUtils;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.Base64;
import tigase.xmpp.impl.CaptchaProvider;
import tigase.xmpp.jid.BareJID;

public abstract class DashboardHandler
implements Handler {
    private static final ThreadLocal<DashboardHandler> HANDLER = new ThreadLocal();
    private static final String CAPTCHA_SECRET_KEY = "captchaSecretKey";
    @Inject
    private DashboardModule module;
    @Inject
    private UserRepository userRepository_;
    protected TemplateEngine engine;
    @ConfigField(desc="Path to template files", alias="templatesPath")
    private String templatesPath;
    private final Random random = new Random();
    private SecretKeySpec secretKey;

    public static boolean canAccess(SecurityContext securityContext, Class<? extends DashboardHandler> clazz, String methodName) {
        Method method = Arrays.stream(clazz.getDeclaredMethods()).filter(it -> it.getName().equals(methodName)).findFirst().orElseThrow();
        Set<String> allowedRoles = Handler.getAllowedRoles(method);
        if (allowedRoles != null) {
            return allowedRoles.stream().anyMatch(arg_0 -> ((SecurityContext)securityContext).isUserInRole(arg_0));
        }
        return true;
    }

    public static DashboardHandler getHandler() {
        return HANDLER.get();
    }

    DashboardHandler() {
        this.setTemplatesPath(null);
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public DashboardModule.CustomAssets getCustomAssets() {
        return this.module.getCustomAssets();
    }

    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
        this.engine = TemplateUtils.create(templatesPath, "tigase.dashboard", ContentType.Html);
    }

    protected String renderTemplate(String templateFile, Map<String, Object> model) {
        try {
            HANDLER.set(this);
            StringOutput output = new StringOutput();
            this.engine.render(templateFile, model, (TemplateOutput)output);
            String string = output.toString();
            return string;
        }
        finally {
            HANDLER.remove();
        }
    }

    protected CaptchaProvider.SimpleTextCaptcha generateCaptcha() {
        return new CaptchaProvider.SimpleTextCaptcha(this.random, this::getSecret);
    }

    protected boolean validateCaptcha(String captchaID, String captchaResponse) {
        if (captchaResponse == null || captchaResponse.isEmpty() || captchaID == null || captchaID.isEmpty()) {
            return false;
        }
        String[] parts = captchaID.split("\\.");
        String type = parts[0];
        if (!"simple-text".equals(type)) {
            return false;
        }
        return new CaptchaProvider.SimpleTextCaptcha(parts).isResponseValid(this::getSecret, captchaResponse);
    }

    private SecretKeySpec getSecret() {
        if (this.secretKey == null) {
            try {
                String secretKeyStr;
                BareJID user = BareJID.bareJIDInstanceNS((String)this.module.getComponentName());
                try {
                    if (!this.userRepository_.userExists(user)) {
                        this.userRepository_.addUser(user);
                    }
                }
                catch (UserExistsException userExistsException) {}
                if ((secretKeyStr = this.userRepository_.getData(user, CAPTCHA_SECRET_KEY)) == null) {
                    SecureRandom random = new SecureRandom();
                    byte[] secret = new byte[32];
                    random.nextBytes(secret);
                    String newSecretKeyStr = Base64.encode((byte[])secret);
                    secretKeyStr = this.userRepository_.getData(user, CAPTCHA_SECRET_KEY);
                    if (secretKeyStr == null) {
                        this.userRepository_.setData(user, CAPTCHA_SECRET_KEY, newSecretKeyStr);
                        Thread.sleep(500L);
                        secretKeyStr = this.userRepository_.getData(user, CAPTCHA_SECRET_KEY);
                    }
                }
                this.secretKey = new SecretKeySpec(Base64.decode((String)secretKeyStr), "HmacSHA256");
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.secretKey;
    }
}

