/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import tigase.http.AuthProvider;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.JaxRsModule;
import tigase.http.modules.AbstractBareModule;
import tigase.kernel.beans.Inject;

public abstract class AbstractJaxRsModule<H extends Handler>
extends AbstractBareModule
implements JaxRsModule<H> {
    @Inject(nullAllowed=true)
    private AuthProvider authProvider;
    private ScheduledExecutorService executorService;
    @Inject(nullAllowed=true)
    private List<H> handlers = new ArrayList<H>();

    @Override
    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    @Override
    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public List<H> getHandlers() {
        return this.handlers;
    }

    @Override
    public void start() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        super.start();
    }

    @Override
    public void stop() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        super.stop();
    }
}

