/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload.logic;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tigase.http.upload.logic.DefaultLogic;
import tigase.xmpp.jid.JID;

public class UriFormat {
    private final HashSet<String> groups = new HashSet();
    private final Pattern pattern;
    private final String template;

    public UriFormat(String format) {
        this.template = format;
        int jidIdx = format.indexOf("{userJid}");
        int domainIdx = format.indexOf("{domain}");
        int slotIdx = format.indexOf("{slotId}");
        int filenameIdx = format.indexOf("{filename}");
        int idx = Math.min(slotIdx, filenameIdx);
        if (idx < 0) {
            throw new RuntimeException("Invalid URI format - must contain {slotId} and {filename}");
        }
        this.groups.add("slotId");
        this.groups.add("filename");
        if (jidIdx > -1) {
            idx = Math.min(idx, jidIdx);
            this.groups.add("jid");
        }
        if (domainIdx > -1) {
            idx = Math.min(idx, domainIdx);
            this.groups.add("domain");
        }
        String infoTemp = format.substring(idx).replace("/", "\\/");
        infoTemp = infoTemp.replace("{userJid}", "(?<jid>[^/]+)").replace("{slotId}", "(?<slotId>[^/]+)").replace("{filename}", "(?<filename>[^/]+)");
        this.pattern = Pattern.compile(infoTemp);
    }

    public String formatUri(DefaultLogic.HttpProtocol protocol, String serverName, int port, JID requester, String slotId, String filename) {
        String format = this.template;
        return format.replace("{proto}", protocol.name()).replace("{serverName}", serverName).replace("{port}", String.valueOf(port)).replace("{domain}", requester.getDomain()).replace("{userJid}", requester.getBareJID().toString()).replace("{slotId}", slotId).replace("{filename}", URLEncoder.encode(filename, StandardCharsets.UTF_8));
    }

    public Matcher parsePath(String path) {
        return this.pattern.matcher(path);
    }

    public boolean hasGroup(String group) {
        return this.groups.contains(group);
    }

    public String getFormat() {
        return this.template;
    }
}

