/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import tigase.http.jaxrs.Handler;
import tigase.http.modules.setup.Config;
import tigase.http.modules.setup.NextPage;
import tigase.http.modules.setup.SetupHandler;
import tigase.http.modules.setup.SetupModule;
import tigase.http.util.TemplateUtils;
import tigase.kernel.beans.Inject;

public abstract class AbstractPage
implements SetupHandler {
    protected final TemplateEngine engine = TemplateUtils.create(null, "tigase.setup", ContentType.Html);
    @Inject(nullAllowed=true)
    protected SetupModule setupModule;

    public Config getConfig() {
        return this.setupModule.getConfig();
    }

    @Override
    public String getPath() {
        return this.getClass().getAnnotation(Path.class).value();
    }

    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.Admin;
    }

    public Map<String, Object> prepareContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("pages", this.setupModule.getHandlers());
        context.put("currentPage", this);
        context.put("config", this.getConfig());
        return context;
    }

    protected String getNextPagePath(HttpServletRequest request) {
        Class<? extends SetupHandler> nextClass = this.getClass().getAnnotation(NextPage.class).value();
        SetupHandler nextHandler = this.setupModule.getHandlers().stream().filter(nextClass::isInstance).findFirst().get();
        return request.getRequestURL().toString().replace(this.getPath(), nextHandler.getPath());
    }

    protected Response redirectToNext(HttpServletRequest request) {
        String uri = this.getNextPagePath(request);
        return Response.seeOther((URI)URI.create(uri)).build();
    }
}

