/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpStatus;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.Model;
import tigase.http.modules.dashboard.DashboardHandler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.kernel.beans.Bean;

@Bean(name="error", parent=DashboardModule.class, active=true)
@Path(value="/error")
public class ErrorHandler
extends DashboardHandler {
    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.None;
    }

    @GET
    @Path(value="/global")
    @Produces(value={"text/html"})
    public Response globalGet(HttpServletRequest request, Model model) {
        return this.globalError(request, model);
    }

    @POST
    @Path(value="/global")
    @Produces(value={"text/html"})
    public Response globalPost(HttpServletRequest request, Model model) {
        return this.globalError(request, model);
    }

    @PUT
    @Path(value="/global")
    @Produces(value={"text/html"})
    public Response globalPut(HttpServletRequest request, Model model) {
        return this.globalError(request, model);
    }

    @DELETE
    @Path(value="/global")
    @Produces(value={"text/html"})
    public Response globalDelete(HttpServletRequest request, Model model) {
        return this.globalError(request, model);
    }

    public Response globalError(HttpServletRequest request, Model model) {
        request.getAttributeNames().asIterator().forEachRemaining(attName -> System.out.println(attName + " = " + String.valueOf(request.getAttribute(attName))));
        int code = (Integer)request.getAttribute("javax.servlet.error.status_code");
        model.put("code", code);
        model.put("message", HttpStatus.getMessage((int)code));
        model.put("reason", request.getAttribute("javax.servlet.error.message"));
        Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (throwable != null) {
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            model.put("exception", throwable);
            model.put("stacktrace", writer.toString());
        }
        String output = this.renderTemplate("error.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }
}

