/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.admin.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import tigase.xml.Element;

public class Reported {
    private final String label;
    private List<FieldDefinition> fields;
    private List<Item> items = new ArrayList<Item>();

    public Reported(Element reportedEl) {
        this.label = reportedEl.getAttributeStaticStr("label");
        this.fields = Optional.ofNullable(reportedEl.getChildren()).map(fields -> fields.stream().map(FieldDefinition::new).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public String getLabel() {
        return this.label;
    }

    public List<FieldDefinition> getFields() {
        return this.fields;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public static class FieldDefinition {
        private final Element field;

        public FieldDefinition(Element field) {
            this.field = field;
        }

        public String getLabel() {
            return Optional.ofNullable(this.field.getAttributeStaticStr("label")).orElseGet(() -> this.field.getAttributeStaticStr("var"));
        }

        public String getVar() {
            return this.field.getAttributeStaticStr("var");
        }

        public String getStyle() {
            return Optional.ofNullable(this.field.getAttributeStaticStr("align")).map(align -> "text-align: " + align).orElse(null);
        }
    }

    public static class Item {
        private List<Element> fields;

        public Item(Element el) {
            this.fields = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList());
        }

        public Field getField(String var) {
            return this.fields.stream().filter(el -> var.equals(el.getAttributeStaticStr("var"))).findFirst().map(Field::new).orElse(null);
        }

        public List<Element> getFields() {
            return this.fields;
        }

        public static class Field {
            private final Element field;

            public Field(Element field) {
                this.field = field;
            }

            public String getValueLabel() {
                return Optional.ofNullable(this.field.getChildAttributeStaticStr("value", "label")).orElseGet(() -> this.field.getChildCDataStaticStr(new String[]{"field", "value"}));
            }
        }
    }
}

