/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs.marshallers;

import jakarta.xml.bind.MarshalException;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import tigase.http.jaxrs.marshallers.AbstractMarshaller;
import tigase.http.jaxrs.marshallers.Marshaller;
import tigase.xml.XMLUtils;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class XmlMarshaller
extends AbstractMarshaller
implements Marshaller {
    private static final String DEFAULT = "##default";
    private static final Map<Class, Function<Object, String>> DEFAULT_SERIALIZERS = new HashMap<Class, Function<Object, String>>();
    private final Map<Class, Function<Object, String>> SERIALIZERS = new HashMap<Class, Function<Object, String>>(DEFAULT_SERIALIZERS);

    static {
        List.of(Long.class, Double.class, Integer.class, Float.class, UUID.class, LocalTime.class).forEach(clazz -> {
            Function<Object, String> function = DEFAULT_SERIALIZERS.put((Class)clazz, obj -> obj.toString());
        });
        List.of(ZonedDateTime.class).forEach(clazz -> {
            Function<Object, String> function = DEFAULT_SERIALIZERS.put((Class)clazz, obj -> ((ZonedDateTime)obj).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        });
        List.of(LocalDateTime.class, LocalDate.class).forEach(clazz -> {
            Function<Object, String> function = DEFAULT_SERIALIZERS.put((Class)clazz, obj -> obj.toString());
        });
        DEFAULT_SERIALIZERS.put(String.class, obj -> (String)obj);
        DEFAULT_SERIALIZERS.put(Date.class, obj -> ZonedDateTime.ofInstant(((Date)obj).toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        DEFAULT_SERIALIZERS.put(JID.class, obj -> obj.toString());
        DEFAULT_SERIALIZERS.put(BareJID.class, obj -> obj.toString());
    }

    public static boolean isNotDefault(String value) {
        return !DEFAULT.equals(value);
    }

    @Override
    public void marshall(Object object, OutputStream outputStream) throws MarshalException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            this.marshall(object, writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void marshall(Object object, Writer writer) throws IOException, MarshalException {
        Class<?> clazz = object.getClass();
        try {
            XmlRootElement xmlRootElement = clazz.getAnnotation(XmlRootElement.class);
            String name = Optional.ofNullable(xmlRootElement).map(XmlRootElement::name).filter(XmlMarshaller::isNotDefault).orElse(clazz.getSimpleName());
            Optional<String> namespace = Optional.ofNullable(xmlRootElement).map(XmlRootElement::namespace).filter(XmlMarshaller::isNotDefault);
            this.marshall(object, name, namespace, writer);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MarshalException("Could not marshal instance of " + clazz.getName(), (Throwable)e);
        }
    }

    public void marshall(Object object, String name, Optional<String> namespace, Writer writer) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        writer.write("<");
        writer.write(name);
        Class<?> clazz = object.getClass();
        if (namespace.isPresent()) {
            writer.write(" xmlns=\"");
            writer.write(namespace.get());
            writer.write("\"");
        }
        Field[] fields = clazz.getDeclaredFields();
        List attributeFields = Arrays.stream(fields).filter(field -> field.getAnnotation(XmlAttribute.class) != null).collect(Collectors.toList());
        for (Field field2 : attributeFields) {
            String valueStr;
            Object value = this.getFieldValue(object, field2);
            if (value == null || (valueStr = this.serialize(value)) == null) continue;
            writer.write(" ");
            writer.write(Optional.ofNullable(field2.getAnnotation(XmlAttribute.class)).map(XmlAttribute::name).filter(XmlMarshaller::isNotDefault).orElse(field2.getName()));
            writer.write("=\"");
            writer.write(XMLUtils.escape((String)valueStr));
            writer.write("\"");
        }
        List elementFields = Arrays.stream(fields).filter(field -> field.getAnnotation(XmlAttribute.class) == null).collect(Collectors.toList());
        if (elementFields.isEmpty()) {
            writer.write("/>");
        } else {
            writer.write(">");
            for (Field field3 : elementFields) {
                Object value = this.getFieldValue(object, field3);
                if (value == null) continue;
                if (value instanceof Collection) {
                    for (Object item : (Collection)value) {
                        this.serializeValue(field3, item, writer);
                    }
                    continue;
                }
                this.serializeValue(field3, value, writer);
            }
            writer.write("</");
            writer.write(name);
            writer.write(">");
        }
    }

    protected void serializeValue(Field field, Object value, Writer writer) throws IOException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String fieldName = Optional.ofNullable(field.getAnnotation(XmlElement.class)).map(XmlElement::name).filter(XmlMarshaller::isNotDefault).orElse(field.getName());
        String valueStr = this.serialize(value);
        if (valueStr == null) {
            this.marshall(value, fieldName, Optional.ofNullable(field.getAnnotation(XmlElement.class)).map(XmlElement::namespace).filter(XmlMarshaller::isNotDefault).or(() -> Optional.ofNullable(field.getClass().getAnnotation(XmlRootElement.class)).map(XmlRootElement::namespace).filter(XmlMarshaller::isNotDefault)), writer);
        } else {
            writer.write("<");
            writer.write(fieldName);
            writer.write(">");
            writer.write(XMLUtils.escape((String)valueStr));
            writer.write("</");
            writer.write(fieldName);
            writer.write(">");
        }
    }

    protected String serialize(Object value) {
        Function<Object, String> serializer = this.SERIALIZERS.get(value.getClass());
        if (serializer == null) {
            if (value instanceof Enum) {
                return ((Enum)value).name();
            }
            return null;
        }
        return serializer.apply(value);
    }
}

