/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import java.util.ArrayList;
import java.util.List;
import tigase.http.jaxrs.Pageable;

public record Page<T>(Pageable pageable, int totalCount, List<T> items) {
    public boolean isFirst() {
        return this.pageable.pageNumber() == 0;
    }

    public boolean isLast() {
        return (this.pageable.pageNumber() + 1) * this.pageable.pageSize() >= this.totalCount;
    }

    public boolean hasPrevous() {
        return !this.isFirst();
    }

    public boolean hasNext() {
        return !this.isLast();
    }

    public Pageable nextPageable() {
        return this.pageable.next();
    }

    public Pageable previousPageable() {
        return this.pageable.previous();
    }

    public int totalPages() {
        return (int)Math.ceil((double)this.totalCount / (double)this.pageable.pageSize());
    }

    public List<Integer> paginate(int oddNoOfItems) {
        int part = oddNoOfItems / 2;
        int currentPage = this.pageable.pageNumber();
        int start = 0;
        int end = 0;
        if (this.totalPages() / 2 > currentPage) {
            start = Math.max(1, currentPage + 1 - part);
            end = Math.min(this.totalPages(), start + oddNoOfItems - 1);
        } else {
            end = Math.min(this.totalPages(), currentPage + 1 + part);
            start = Math.max(1, end - oddNoOfItems + 1);
        }
        ArrayList<Integer> pages = new ArrayList<Integer>();
        int i = start;
        while (i <= end) {
            pages.add(i);
            ++i;
        }
        return pages;
    }
}

