/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.AuthenticationException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.auth.credentials.Credentials;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.http.AuthProvider;
import tigase.http.HttpMessageReceiver;
import tigase.http.json.JsonParser;
import tigase.http.json.JsonSerializer;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="authProvider", parent=HttpMessageReceiver.class, active=true, exportable=true)
public class AuthProviderImpl
implements AuthProvider,
Initializable {
    private static final String JWT_SECRET_KEY = "jwtSecretKey";
    @Inject(nullAllowed=true)
    private UserRepository userRepository;
    @Inject(nullAllowed=true)
    private AuthRepository authRepository;
    @Inject(bean="service")
    private HttpMessageReceiver receiver;
    private SecretKeySpec secretKey;
    private final JsonSerializer jsonSerializer = new JsonSerializer();

    public void initialize() {
        if (this.userRepository != null) {
            BareJID user = BareJID.bareJIDInstanceNS((String)this.receiver.getName());
            try {
                String secretKeyStr;
                try {
                    if (!this.userRepository.userExists(user)) {
                        this.userRepository.addUser(user);
                    }
                }
                catch (UserExistsException userExistsException) {}
                if ((secretKeyStr = this.userRepository.getData(user, JWT_SECRET_KEY)) == null) {
                    SecureRandom random = new SecureRandom();
                    byte[] secret = new byte[32];
                    random.nextBytes(secret);
                    String newSecretKeyStr = Base64.encode((byte[])secret);
                    secretKeyStr = this.userRepository.getData(user, JWT_SECRET_KEY);
                    if (secretKeyStr == null) {
                        this.userRepository.setData(user, JWT_SECRET_KEY, newSecretKeyStr);
                        Thread.sleep(500L);
                        secretKeyStr = this.userRepository.getData(user, JWT_SECRET_KEY);
                    }
                }
                this.secretKey = new SecretKeySpec(Base64.decode((String)secretKeyStr), "HmacSHA256");
            }
            catch (Throwable ex) {
                throw new RuntimeException("Failed to generate and store secret key!", ex);
            }
        }
    }

    @Override
    public boolean isAdmin(BareJID user) {
        return this.receiver.isAdmin(JID.jidInstance((BareJID)user));
    }

    @Override
    public List<String> getRoles(BareJID user) {
        List<String> roles = AuthProvider.super.getRoles(user);
        try {
            String[] rolesFromRepo = this.userRepository.getDataList(user, "roles", "roles");
            if (rolesFromRepo != null) {
                roles.addAll(Arrays.asList(rolesFromRepo));
            }
        }
        catch (TigaseDBException ex) {
            throw new RuntimeException("Failed to load user " + String.valueOf(user) + " roles", ex);
        }
        return roles;
    }

    @Override
    public String generateToken(AuthProvider.JWTPayload token) throws NoSuchAlgorithmException, InvalidKeyException {
        Map<String, String> header = Map.of("alg", "HS256", "typ", "JWT");
        Map<String, Long> payload = Map.of("sub", token.subject().toString(), "iss", token.issuer(), "exp", token.expireAt().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli());
        String data = Base64.encode((byte[])this.jsonSerializer.serialize(header).getBytes(StandardCharsets.UTF_8)) + "." + Base64.encode((byte[])this.jsonSerializer.serialize(payload).getBytes(StandardCharsets.UTF_8));
        return data + "." + this.calculateTokenSignature(data);
    }

    private String calculateTokenSignature(String data) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(this.secretKey);
        return Base64.encode((byte[])mac.doFinal(data.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public AuthProvider.JWTPayload parseToken(String token) throws AuthenticationException {
        String[] parts = token.split("\\.");
        if (parts.length != 3) {
            throw new AuthenticationException("Incorrect JWT token");
        }
        try {
            Map header = (Map)JsonParser.parseJson(Base64.decode((String)parts[0]));
            if ("HS256".equals(header.get("alg")) && "JWT".equals(header.get("typ")) && parts[2].equals(this.calculateTokenSignature(parts[0] + "." + parts[1]))) {
                Map payload = (Map)JsonParser.parseJson(Base64.decode((String)parts[1]));
                Number exp = (Number)payload.get("exp");
                LocalDateTime expireAt = Instant.ofEpochMilli(exp.longValue()).atZone(ZoneId.of("UTC")).toLocalDateTime();
                if (expireAt.isBefore(LocalDateTime.now())) {
                    throw new AuthenticationException("JWT token is expired");
                }
                BareJID subject = BareJID.bareJIDInstance((String)((String)payload.get("sub")));
                String issuer = (String)payload.get("iss");
                return new AuthProvider.JWTPayload(subject, issuer, expireAt);
            }
            throw new AuthenticationException("Incorrect JWT token");
        }
        catch (AuthenticationException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            throw new AuthenticationException("Incorrect JWT token");
        }
    }

    @Override
    public void refreshJwtToken(HttpServletRequest request, HttpServletResponse response) {
        AuthProvider.JWTPayload payload = (AuthProvider.JWTPayload)request.getAttribute("refreshJwtToken");
        if (payload != null) {
            try {
                System.out.println("refreshing JWT token for " + String.valueOf(payload.subject()));
                this.setAuthenticationCookie(response, new AuthProvider.JWTPayload(payload.subject(), payload.issuer(), LocalDateTime.now().plusMinutes(15L)), request.getServerName(), request.getContextPath());
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public AuthProvider.JWTPayload authenticateWithCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals("jwtToken")) {
                    try {
                        AuthProvider.JWTPayload payload = this.parseToken(cookie.getValue());
                        if (payload != null && payload.expireAt().isBefore(LocalDateTime.now().plusMinutes(5L))) {
                            request.setAttribute("refreshJwtToken", (Object)payload);
                        }
                        return payload;
                    }
                    catch (AuthenticationException authenticationException) {}
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void setAuthenticationCookie(HttpServletResponse response, AuthProvider.JWTPayload payload, String domain, String path) throws NoSuchAlgorithmException, InvalidKeyException {
        String value = this.generateToken(payload);
        this.setAuthCookie(response, domain, path, value, payload.expireAt());
    }

    @Override
    public void resetAuthenticationCookie(HttpServletResponse response, String domain, String path) {
        this.setAuthCookie(response, domain, path, "", LocalDateTime.now().minusDays(1L));
    }

    private void setAuthCookie(HttpServletResponse response, String domain, String path, String value, LocalDateTime expireAt) {
        StringBuilder sb = new StringBuilder("jwtToken").append("=").append(value);
        sb.append("; ").append("Domain=").append(domain).append("; Path=").append(path);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz");
        String expireAtStr = expireAt.atZone(ZoneId.of("GMT")).format(formatter);
        String cookieValue = sb.append("; ").append("Expires=").append(expireAtStr).toString();
        response.setHeader("Set-Cookie", cookieValue);
    }

    @Override
    public boolean checkCredentials(String user, String password) throws TigaseStringprepException, TigaseDBException {
        Credentials credentials;
        block4: {
            if (this.authRepository == null) {
                return false;
            }
            try {
                BareJID jid = BareJID.bareJIDInstance((String)user);
                credentials = this.authRepository.getCredentials(jid, "default");
                if (credentials != null) break block4;
                return false;
            }
            catch (UserNotFoundException userNotFoundException) {
                return false;
            }
        }
        return Optional.ofNullable(credentials.getFirst()).map(e -> e.verifyPlainPassword(password)).orElse(false);
    }
}

