/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.util.Algorithms;

public class AssetsServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp, true);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp, false);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp, boolean sendContent) throws IOException {
        String ifNoneMatch;
        String reqFile = req.getPathInfo();
        if (reqFile == null) {
            resp.sendError(404);
            return;
        }
        String path = "/tigase/assets" + (reqFile = URLDecoder.decode(reqFile, StandardCharsets.UTF_8));
        URL fileUrl = AssetsServlet.class.getResource(path);
        if (fileUrl == null) {
            resp.sendError(404);
            return;
        }
        String etag = null;
        URLConnection connection = fileUrl.openConnection();
        long lastModified = connection.getLastModified();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(("" + lastModified).getBytes(StandardCharsets.UTF_8));
            etag = Algorithms.bytesToHex((byte[])md.digest(reqFile.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        String filename = reqFile;
        int idx = reqFile.lastIndexOf(47);
        if (idx >= 0) {
            filename = filename.substring(idx + 1);
        }
        if ((ifNoneMatch = req.getHeader("If-None-Match")) != null && ifNoneMatch.equalsIgnoreCase(etag)) {
            resp.setStatus(304);
            resp.setHeader("ETag", etag);
            resp.setDateHeader("Expires", System.currentTimeMillis() + 60000L);
            return;
        }
        long ifModifiedSince = req.getDateHeader("If-Modified-Since");
        if (ifNoneMatch == null && ifModifiedSince != 1L && ifModifiedSince + 1000L > lastModified) {
            resp.setStatus(304);
            resp.setHeader("ETag", etag);
            resp.setDateHeader("Expires", System.currentTimeMillis() + 60000L);
            return;
        }
        resp.setDateHeader("Last-Modified", lastModified);
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(filename);
        if (contentType == null) {
            contentType = filename.endsWith(".css") ? "text/css" : "application/octet-stream";
        }
        resp.setHeader("ETag", etag);
        resp.setDateHeader("Expires", System.currentTimeMillis() + 60000L);
        resp.setContentType(contentType);
        resp.setContentLength(connection.getContentLength());
        if (sendContent) {
            Throwable throwable = null;
            Object var18_17 = null;
            try (InputStream is = connection.getInputStream();){
                is.transferTo((OutputStream)resp.getOutputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

