/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload.db;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import tigase.annotations.TigaseDeprecated;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.TigaseDBException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public interface FileUploadRepository<DS extends DataSource>
extends DataSourceAware<DS> {
    public Slot allocateSlot(BareJID var1, String var2, String var3, long var4, String var6) throws TigaseDBException;

    @TigaseDeprecated(since="2.2.0", removeIn="3.0.0", note="Use method allocateSlot() with sender as a BareJID")
    @Deprecated
    default public Slot allocateSlot(JID sender, String slotId, String filename, long filesize, String contentType) throws TigaseDBException {
        return this.allocateSlot(sender.getBareJID(), slotId, filename, filesize, contentType);
    }

    public void updateSlot(BareJID var1, String var2) throws TigaseDBException;

    public Slot getSlot(BareJID var1, String var2) throws TigaseDBException;

    public List<Slot> listExpiredSlots(BareJID var1, LocalDateTime var2, int var3) throws TigaseDBException;

    public void removeExpiredSlots(BareJID var1, LocalDateTime var2, int var3) throws TigaseDBException;

    public long getUsedSpaceForDomain(String var1) throws TigaseDBException;

    public long getUsedSpaceForUser(BareJID var1) throws TigaseDBException;

    public List<Slot> querySlots(BareJID var1, String var2, int var3) throws TigaseDBException;

    public List<Slot> querySlots(String var1, String var2, int var3) throws TigaseDBException;

    public void removeSlot(BareJID var1, String var2) throws TigaseDBException;

    public static class Slot {
        public final String contentType;
        public final String filename;
        public final long filesize;
        public final String slotId;
        public final Date timestamp;
        public final BareJID uploader;

        public Slot(BareJID uploader, String slotId, String filename, long filesize, String contentType, Date timestamp) {
            this.uploader = uploader;
            this.slotId = slotId;
            this.filename = filename;
            this.filesize = filesize;
            this.contentType = contentType;
            this.timestamp = timestamp;
        }

        public boolean matches(String slotId, long filesize, String contentType) {
            return this.slotId.equals(slotId) && this.filesize == filesize && (this.contentType == null || this.contentType.equals(contentType));
        }
    }
}

