/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload;

import tigase.component.exceptions.ComponentException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;

public class FileTooLargeException
extends ComponentException {
    private final long limit;

    public FileTooLargeException(long limit) {
        super(Authorization.NOT_ACCEPTABLE, "File too large. The maximum file size is " + limit + " bytes");
        this.limit = limit;
    }

    public Packet makeElement(Packet packet, boolean insertOriginal) throws PacketErrorTypeException {
        Packet result = super.makeElement(packet, insertOriginal);
        Element error = result.getElemChild("error");
        if (error != null) {
            Element fileTooLargeEl = new Element("file-too-large");
            fileTooLargeEl.setXMLNS("urn:xmpp:http:upload:0");
            fileTooLargeEl.addChild((XMLNodeIfc)new Element("max-file-size", String.valueOf(this.limit)));
            error.addChild((XMLNodeIfc)fileTooLargeEl);
        }
        return result;
    }
}

