/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WarServlet
extends HttpServlet {
    public static final String WAR_PATH_KEY = "war-path";
    private static final Logger log = Logger.getLogger(WarServlet.class.getCanonicalName());
    private ZipFile war;

    public void init() throws ServletException {
        super.init();
        ServletConfig cfg = super.getServletConfig();
        String warPath = cfg.getInitParameter(WAR_PATH_KEY);
        try {
            this.war = new ZipFile(warPath);
        }
        catch (IOException ex) {
            log.log(Level.FINE, "Could not initialize servlet, wrong path " + warPath + " to WAR archive?", ex);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ZipEntry e;
        URI uri = URI.create(req.getRequestURI());
        String path = uri.getPath();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "got request for {0} and servlet path {1} context {2}", new Object[]{path, req.getServletPath(), req.getContextPath()});
        }
        if (path.startsWith(req.getContextPath())) {
            path = path.substring(req.getContextPath().length());
        }
        if (path.startsWith(req.getServletPath())) {
            path = path.substring(req.getServletPath().length());
        }
        if (path.isEmpty() || path.equals("/")) {
            path = "index.html";
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "converted to request for file from relative path {0}", path);
        }
        if ((e = this.war.getEntry(path)) == null) {
            resp.sendError(404, "404 Not found");
            return;
        }
        byte[] buf = new byte[4096];
        Throwable throwable = null;
        Object var8_9 = null;
        try (InputStream in = this.war.getInputStream(e);){
            int read;
            ServletOutputStream out = resp.getOutputStream();
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void finalize() throws Throwable {
        if (this.war != null) {
            this.war.close();
        }
        super.finalize();
    }
}

