/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest.users;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import tigase.http.ServiceImpl;
import tigase.http.api.NotFoundException;
import tigase.http.api.Service;
import tigase.http.api.rest.RestHandler;
import tigase.http.jaxrs.Handler;
import tigase.http.modules.rest.AbstractRestHandler;
import tigase.http.modules.rest.RestModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="avatarGet", parent=RestModule.class, active=false)
@Path(value="/avatar")
public class AvatarGetHandler
extends AbstractRestHandler {
    private static final Pattern DATA_PATTERN = Pattern.compile("data:(.+);base64,(.+)");
    private static final String[] PEP_DATA_PATH = new String[]{"iq", "pubsub", "items", "item", "data"};
    private static final String[] PEP_METADATA_PATH = new String[]{"iq", "pubsub", "items", "item", "metadata"};
    private static final String[] VCARD_TEMP_PHOTO_PATH = new String[]{"iq", "vCard", "PHOTO"};
    private static final String[] VCARD4_PHOTO_URI_PATH = new String[]{"iq", "vCard", "PHOTO"};
    @Inject
    private RestModule restModule;
    private Service<RestModule> service;

    public AvatarGetHandler() {
        super(RestHandler.Security.None, Handler.Role.None);
    }

    public RestModule getRestModule() {
        return this.restModule;
    }

    public void setRestModule(RestModule restModule) {
        this.restModule = restModule;
        this.service = new ServiceImpl<RestModule>(restModule);
    }

    @GET
    @Path(value="/{user}(/{source})?")
    public void retrieveAvatar(@NotNull @PathParam(value="user") String userStr, @PathParam(value="source") Source source, @Suspended AsyncResponse asyncResponse) {
        BareJID user = BareJID.bareJIDInstanceNS((String)userStr);
        ((CompletableFuture)this.getAvatar(user, source).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            asyncResponse.resume(ex);
            return null;
        });
    }

    public CompletableFuture<Response> getAvatar(BareJID userJid, Source source) {
        if (source != null) {
            return switch (source) {
                case Source.pep -> this.getAvatarFromPEP(userJid);
                case Source.vcard4 -> this.getAvatarFromVCard4(userJid);
                case Source.vcardTemp -> this.getAvatarFromVCardTemp(userJid);
                default -> throw new IncompatibleClassChangeError();
            };
        }
        return ((CompletableFuture)this.getAvatarFromPEP(userJid).exceptionallyCompose(ex1 -> this.getAvatarFromVCard4(userJid))).exceptionallyCompose(ex2 -> this.getAvatarFromVCardTemp(userJid));
    }

    public CompletableFuture<Response> getAvatarFromPEP(BareJID userJid) {
        Element iqEl = new Element("iq").withAttribute("type", "get").withElement("pubsub", "http://jabber.org/protocol/pubsub", pubsubEl -> pubsubEl.withElement("items", itemsEl -> itemsEl.withAttribute("node", "urn:xmpp:avatar:metadata").withAttribute("max_items", "1")));
        Iq iq = new Iq(iqEl, null, JID.jidInstance((BareJID)userJid));
        return this.service.sendPacketAndWait((Packet)iq, 30).thenCompose(result -> {
            Optional<String> infos = Optional.ofNullable(result.getElement().getChildren(PEP_METADATA_PATH)).flatMap(el -> el.stream().filter(it -> "info".equals(it.getName())).findFirst());
            if (infos.isPresent()) {
                Optional<URI> uri = infos.map(info -> info.getAttributeStaticStr("url")).map(urlStr -> {
                    try {
                        return new URI((String)urlStr);
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                });
                if (uri.isPresent()) {
                    return CompletableFuture.completedFuture(Response.temporaryRedirect((URI)uri.get()).build());
                }
                Optional<String> id = infos.map(it -> it.getAttributeStaticStr("id"));
                Optional<String> mimeType = infos.map(it -> it.getAttributeStaticStr("type"));
                if (id.isPresent() && mimeType.isPresent()) {
                    return this.getAvatarDataFromPEP(userJid, id.get(), mimeType.get());
                }
            }
            return CompletableFuture.failedFuture(new NotFoundException());
        });
    }

    public CompletableFuture<Response> getAvatarDataFromPEP(BareJID userJid, String id, String mimeType) {
        Element iqEl = new Element("iq").withAttribute("type", "get").withElement("pubsub", "http://jabber.org/protocol/pubsub", pubsubEl -> pubsubEl.withElement("items", itemsEl -> itemsEl.withAttribute("node", "urn:xmpp:avatar:data").withElement("item", itemEl -> {
            Element element = itemEl.withAttribute("id", id);
        })));
        Iq iq = new Iq(iqEl, null, JID.jidInstance((BareJID)userJid));
        return this.service.sendPacketAndWait((Packet)iq, 30).thenCompose(result -> {
            Optional<byte[]> data = Optional.ofNullable(result.getElement().getChildCData(PEP_DATA_PATH)).map(XMLUtils::unescape).map(str -> str.replace("\n", "").replace("\r", "")).map(Base64::decode);
            if (data.isPresent()) {
                return CompletableFuture.completedFuture(Response.ok((Object)data.get(), (String)mimeType).build());
            }
            return CompletableFuture.failedFuture(new NotFoundException());
        });
    }

    public CompletableFuture<Response> getAvatarFromVCard4(BareJID userJid) {
        Element iqEl = new Element("iq").withAttribute("type", "get").withElement("vcard", "urn:ietf:params:xml:ns:vcard-4.0", null);
        Iq iq = new Iq(iqEl, null, JID.jidInstance((BareJID)userJid));
        return this.service.sendPacketAndWait((Packet)iq, 30).thenCompose(result -> {
            Optional<String> photoUri = Optional.ofNullable(result.getElement().getCData(VCARD4_PHOTO_URI_PATH)).map(XMLUtils::unescape).map(str -> str.replace("\n", "").replace("\r", ""));
            if (photoUri.isPresent()) {
                Matcher matcher = DATA_PATTERN.matcher(photoUri.get());
                if (matcher.matches()) {
                    String mimetype = matcher.group(0);
                    String data = matcher.group(1);
                    return CompletableFuture.completedFuture(Response.ok((Object)Base64.decode((String)data), (String)mimetype).build());
                }
                try {
                    URI url = new URI(photoUri.get());
                    return CompletableFuture.completedFuture(Response.temporaryRedirect((URI)url).build());
                }
                catch (Throwable throwable) {}
            }
            return CompletableFuture.failedFuture(new NotFoundException());
        });
    }

    public CompletableFuture<Response> getAvatarFromVCardTemp(BareJID userJid) {
        Element iqEl = new Element("iq").withAttribute("type", "get").withElement("vCard", "vcard-temp", null);
        Iq iq = new Iq(iqEl, null, JID.jidInstance((BareJID)userJid));
        return this.service.sendPacketAndWait((Packet)iq, 30).thenCompose(result -> {
            Element photoEl = result.getElement().findChild(VCARD_TEMP_PHOTO_PATH);
            if (photoEl != null) {
                Optional<URI> url = Optional.ofNullable(photoEl.getChild("EXTVAL")).map(Element::getCData).map(XMLUtils::unescape).map(urlStr -> {
                    try {
                        return new URI((String)urlStr);
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                });
                if (url.isPresent()) {
                    return CompletableFuture.completedFuture(Response.temporaryRedirect((URI)url.get()).build());
                }
                Optional<String> mimeType = Optional.ofNullable(photoEl.getChild("TYPE")).map(Element::getCData).map(XMLUtils::unescape);
                Optional<byte[]> data = Optional.ofNullable(photoEl.getChild("BINVAL")).map(Element::getCData).map(str -> str.replace("\n", "").replace("\r", "")).map(Base64::decode);
                if (mimeType.isPresent() && data.isPresent()) {
                    return CompletableFuture.completedFuture(Response.ok((Object)data.get(), (String)mimeType.get()).build());
                }
            }
            return CompletableFuture.failedFuture(new NotFoundException());
        });
    }

    public static enum Source {
        pep,
        vcard4,
        vcardTemp;

        private static final Map<String, Source> MAPPING;

        static {
            MAPPING = Arrays.stream(Source.values()).collect(Collectors.toUnmodifiableMap(Source::getValue, Function.identity()));
        }

        public String getValue() {
            return switch (this) {
                case pep -> "pep";
                case vcard4 -> "vcard4";
                case vcardTemp -> "vcard-temp";
                default -> throw new IncompatibleClassChangeError();
            };
        }

        public static Source fromString(String str) {
            return MAPPING.get(str);
        }
    }
}

