/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.admin;

import gg.jte.ContentType;
import gg.jte.TemplateEngine;
import gg.jte.TemplateOutput;
import gg.jte.output.WriterOutput;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.http.modules.AbstractBareModule;
import tigase.http.modules.Module;
import tigase.http.modules.admin.CommandItem;
import tigase.http.modules.admin.form.Form;
import tigase.http.util.TemplateUtils;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class Servlet
extends HttpServlet {
    public static final String MODULE_ID_KEY = "module-id-key";
    public static final String SCRIPTS_DIR_KEY = "scripts-dir";
    private static final Logger log = Logger.getLogger(Servlet.class.getCanonicalName());
    private static final String DISCO_ITEMS_XMLNS = "http://jabber.org/protocol/disco#items";
    private static final String ADHOC_COMMANDS_XMLNS = "http://jabber.org/protocol/commands";
    private File scriptsDir = null;
    private Module module = null;
    private TemplateEngine engine = null;

    public void init() throws ServletException {
        super.init();
        ServletConfig cfg = super.getServletConfig();
        String moduleName = cfg.getInitParameter(MODULE_ID_KEY);
        this.module = AbstractBareModule.getModuleByUUID(moduleName);
        this.scriptsDir = new File(cfg.getInitParameter(SCRIPTS_DIR_KEY));
        this.engine = TemplateUtils.create(null, "tigase.admin", ContentType.Html);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (request.getUserPrincipal() == null) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"TigasePlain\"");
                request.authenticate(response);
                return;
            }
            AsyncContext asyncCtx = request.startAsync((ServletRequest)request, (ServletResponse)response);
            CompletableFuture<List<CommandItem>> future = this.retrieveComponentsCommands(request.getUserPrincipal());
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)future.thenCompose(commands -> {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("commands", commands.stream().collect(Collectors.groupingBy(CommandItem::getGroup)));
                model.put("commandGroups", commands.stream().map(CommandItem::getGroup).distinct().sorted().collect(Collectors.toList()));
                model.put("defaultCommands", Servlet.getDefaultCommands(commands));
                model.put("currentGroup", Optional.ofNullable(request.getParameter("_group")).orElse(""));
                CompletableFuture<HashMap<String, Object>> futureResult = new CompletableFuture<HashMap<String, Object>>();
                Optional<CommandItem> command = Servlet.getCommand(commands, request.getParameter("_jid"), request.getParameter("_node"));
                if (command.isPresent()) {
                    model.put("currentCommand", command.get());
                    ((CompletableFuture)this.processRequestStep(request, command.get()).thenAccept(result -> {
                        model.put("form", new Form(result.getFields()));
                        futureResult.complete(model);
                    })).exceptionally(ex -> {
                        futureResult.completeExceptionally((Throwable)ex);
                        return null;
                    });
                } else {
                    futureResult.complete(model);
                }
                return futureResult;
            })).thenCompose(context -> {
                try {
                    this.engine.render("index.jte", context, (TemplateOutput)new WriterOutput((Writer)asyncCtx.getResponse().getWriter()));
                    return CompletableFuture.completedFuture(null);
                }
                catch (IOException ex) {
                    return CompletableFuture.failedFuture(ex);
                }
            })).exceptionally(ex -> {
                log.log(Level.FINE, "exception processing request", (Throwable)ex);
                try {
                    response.sendError(500);
                }
                catch (Throwable throwable) {}
                return null;
            })).whenComplete((r, ex) -> asyncCtx.complete());
        }
        catch (Exception ex2) {
            log.log(Level.FINE, "exception processing request", ex2);
            response.sendError(500);
        }
    }

    public CompletableFuture<ExecutionResult> processRequestStep(HttpServletRequest request, CommandItem command) {
        return this.processRequestStep(request, command, 1, null);
    }

    public CompletableFuture<ExecutionResult> processRequestStep(HttpServletRequest request, CommandItem command, int iteration, List<Element> formFields) {
        return this.executeAdhocForm(request.getUserPrincipal(), command, formFields).thenCompose(result -> {
            if (result.isFormType(Command.DataType.form) && (this.requestHasValuesForFields(result.getFields(), request) && iteration < 10 || iteration == 1 && "POST".equals(request.getMethod()))) {
                this.setFieldValuesFromRequest(result.getFields(), request, iteration);
                return this.processRequestStep(request, command, iteration + 1, result.getFields());
            }
            return CompletableFuture.completedFuture(result);
        });
    }

    static List<CommandItem> getDefaultCommands(List<CommandItem> commands) {
        CopyOnWriteArrayList<CommandItem> result = new CopyOnWriteArrayList<CommandItem>();
        Servlet.getCommand(commands, "sess-man", "http://jabber.org/protocol/admin#add-user").ifPresent(result::add);
        Servlet.getCommand(commands, "sess-man", "modify-user").ifPresent(result::add);
        Servlet.getCommand(commands, "sess-man", "http://jabber.org/protocol/admin#delete-user").ifPresent(result::add);
        Servlet.getCommand(commands, "sess-man", "http://jabber.org/protocol/admin#get-online-users-list").ifPresent(result::add);
        Servlet.getCommand(commands, "vhost-man", "comp-repo-item-add").ifPresent(e -> {
            e.setName("Add domain");
            result.add((CommandItem)e);
        });
        Servlet.getCommand(commands, "vhost-man", "comp-repo-item-update").ifPresent(e -> {
            e.setName("Configure domain");
            result.add((CommandItem)e);
        });
        Servlet.getCommand(commands, "vhost-man", "comp-repo-item-remove").ifPresent(e -> {
            e.setName("Remove domain");
            result.add((CommandItem)e);
        });
        Servlet.getCommand(commands, "Rest", "api-key-add").ifPresent(e -> {
            e.setName("Add REST-API key");
            result.add((CommandItem)e);
        });
        return result;
    }

    static Optional<CommandItem> getCommand(List<CommandItem> commands, String component, String command) {
        return commands.stream().filter(map -> map.getNode().equals(command) && map.getJid().toString().startsWith(component)).findAny();
    }

    private CompletableFuture<ExecutionResult> executeAdhocForm(Principal principal, CommandItem command, List<Element> formFields) {
        Element iqEl = new Element("iq").withAttribute("xmlns", "jabber:client").withAttribute("type", StanzaType.set.name());
        Element commandEl = new Element("command");
        commandEl.setXMLNS(ADHOC_COMMANDS_XMLNS);
        commandEl.setAttribute("node", command.getNode());
        iqEl.addChild((XMLNodeIfc)commandEl);
        if (formFields != null) {
            Element x = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "submit"});
            formFields.forEach(arg_0 -> ((Element)x).addChild(arg_0));
            commandEl.addChild((XMLNodeIfc)x);
        }
        Packet iq = Packet.packetInstance((Element)iqEl, (JID)JID.jidInstanceNS((String)principal.getName()), (JID)command.getJid());
        CompletableFuture future = this.module.sendPacketAndWait(iq);
        return future.thenApply(result -> {
            ArrayList<Element> fields;
            Element xEl = result.getElement().findChildStaticStr(new String[]{"iq", "command", "x"});
            ArrayList<Element> arrayList = fields = xEl == null ? null : xEl.getChildren();
            if (fields == null) {
                fields = new ArrayList<Element>();
            }
            Command.DataType formType = xEl != null && xEl.getAttributeStaticStr("type") != null ? Command.DataType.valueOf((String)xEl.getAttributeStaticStr("type")) : Command.DataType.result;
            fields.forEach(e -> {
                if (e.getName() != "field") {
                    return;
                }
                if (e.getAttributeStaticStr("type") == null) {
                    e.setAttribute("type", formType == Command.DataType.form ? "text-single" : "fixed");
                }
            });
            if (fields.isEmpty()) {
                fields.add(new Element("title", "Execution completed"));
            }
            return new ExecutionResult(formType, fields);
        });
    }

    private CompletableFuture<List<CommandItem>> retrieveComponentsCommands(Principal principal) {
        CompletionStage allJids = this.retrieveComponents(principal, JID.jidInstanceNS((String)BareJID.bareJIDInstanceNS((String)principal.getName()).getDomain())).thenCombine(this.retrieveComponents(principal, JID.jidInstanceNS((String)this.module.getJid().getDomain())), (componentJids, httpModuleJids) -> Stream.concat(componentJids.stream(), httpModuleJids.stream()));
        return ((CompletableFuture)allJids).thenCompose(componentJids -> {
            CompletableFuture[] componentFutures = (CompletableFuture[])componentJids.map(jid -> this.retrieveComponentCommands(principal, (JID)jid)).toArray(CompletableFuture[]::new);
            CompletionStage commands = CompletableFuture.allOf(componentFutures).thenApply(x -> Arrays.stream(componentFutures).map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList()));
            return commands;
        });
    }

    private CompletableFuture<List<JID>> retrieveComponents(Principal principal, JID to) {
        long start = System.currentTimeMillis();
        Element iqEl = new Element("iq").withAttribute("xmlns", "jabber:client").withAttribute("type", StanzaType.get.name()).withElement("query", DISCO_ITEMS_XMLNS, null);
        Packet iq = Packet.packetInstance((Element)iqEl, (JID)JID.jidInstanceNS((String)principal.getName()), (JID)to);
        CompletionStage future = this.module.sendPacketAndWait(iq, 1).exceptionally(ex -> null);
        return ((CompletableFuture)future).thenApply(result -> {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "discovery of components took {0}ms", System.currentTimeMillis() - start);
            }
            if (result == null || result.getType() != StanzaType.result) {
                log.fine("discovery of components failed");
                return Collections.emptyList();
            }
            return result.getElement().getChild("query", DISCO_ITEMS_XMLNS).mapChildren(item -> JID.jidInstanceNS((String)item.getAttributeStaticStr("jid")));
        });
    }

    private CompletableFuture<List<CommandItem>> retrieveComponentCommands(Principal principal, JID componentJid) {
        long start = System.currentTimeMillis();
        Element iqEl = new Element("iq").withAttribute("xmlns", "jabber:client").withAttribute("type", StanzaType.get.name()).withElement("query", DISCO_ITEMS_XMLNS, queryEl -> {
            Element element = queryEl.withAttribute("node", ADHOC_COMMANDS_XMLNS);
        });
        Packet iq = Packet.packetInstance((Element)iqEl, (JID)JID.jidInstanceNS((String)principal.getName()), (JID)componentJid);
        CompletionStage future = this.module.sendPacketAndWait(iq, 1).exceptionally(ex -> null);
        return ((CompletableFuture)future).thenApply(result -> {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "discovery of commands of component {0} took {1}ms", new Object[]{componentJid, System.currentTimeMillis() - start});
            }
            if (result == null || result.getType() != StanzaType.result) {
                log.log(Level.FINE, "discovery of component {0} adhoc commands failed", componentJid);
                return Collections.emptyList();
            }
            return Optional.ofNullable(result.getElement().getChild("query", DISCO_ITEMS_XMLNS)).stream().map(Element::getChildren).filter(Objects::nonNull).flatMap(Collection::stream).map(Element::getAttributes).map(CommandItem::new).collect(Collectors.toList());
        });
    }

    private boolean requestHasValuesForFields(List<Element> formFields, HttpServletRequest request) {
        ArrayList<String> missing;
        int contains = 0;
        int needed = 0;
        ArrayList<String> arrayList = missing = log.isLoggable(Level.FINEST) ? new ArrayList<String>() : null;
        if (formFields != null) {
            for (Element formField : formFields) {
                String type;
                if (formField.getName() != "field" || (type = formField.getAttributeStaticStr("type")) == null || "boolean".equals(type) || "fixed".equals(type)) continue;
                String name = formField.getAttributeStaticStr("var");
                if (request.getParameter(name) != null || request.getParameterValues(name) != null) {
                    ++contains;
                } else if (name != null && formField.getAttributeStaticStr(String.valueOf(name) + "_date") != null && formField.getAttributeStaticStr(String.valueOf(name) + "_tz") != null) {
                    ++contains;
                } else if (missing != null) {
                    missing.add(name);
                }
                ++needed;
            }
        }
        if (log.isLoggable(Level.FINEST) && contains != needed && needed > 0) {
            log.log(Level.FINEST, "for URI = {0} needed field {1} but got {2}, still missing = {3}", new Object[]{String.valueOf(request.getRequestURI()) + "?" + request.getQueryString(), needed, contains, missing});
        }
        return contains == needed && needed > 0;
    }

    private void setFieldValuesFromRequest(List<Element> formFields, HttpServletRequest request, int iteration) {
        if (formFields == null) {
            return;
        }
        formFields.forEach(formField -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[11] lbl102 : CaseStatement: default:\u000a, @NONE, blocks:[11] lbl102 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private static /* synthetic */ void lambda$40(Element element, List list, Element oldChild) {
        if (oldChild != null) {
            element.removeChild(oldChild);
            list.add(oldChild);
        }
    }

    private static /* synthetic */ boolean lambda$41(String val) {
        return !val.isEmpty();
    }

    private static /* synthetic */ boolean lambda$42(String val) {
        return !val.isEmpty();
    }

    private static /* synthetic */ boolean lambda$43(String val) {
        return !val.isEmpty();
    }

    private static /* synthetic */ TimeZone lambda$44(String val) {
        return TimeZone.getTimeZone(val);
    }

    public class ExecutionResult {
        private final Command.DataType formType;
        private final List<Element> fields;

        public ExecutionResult(Command.DataType formType, List<Element> fields) {
            this.formType = formType;
            this.fields = fields;
        }

        public Command.DataType getFormType() {
            return this.formType;
        }

        public boolean isFormType(Command.DataType formType) {
            return this.formType == formType;
        }

        public List<Element> getFields() {
            return this.fields;
        }
    }
}

