/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.xml.bind.MarshalException;
import jakarta.xml.bind.UnmarshalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import tigase.http.api.HttpException;
import tigase.http.api.UnsupportedFormatException;
import tigase.http.jaxrs.AcceptedType;
import tigase.http.jaxrs.AsyncResponseImpl;
import tigase.http.jaxrs.ContainerRequestContext;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.HttpMethod;
import tigase.http.jaxrs.Model;
import tigase.http.jaxrs.Pageable;
import tigase.http.jaxrs.RequestHandler;
import tigase.http.jaxrs.marshallers.JsonMarshaller;
import tigase.http.jaxrs.marshallers.JsonUnmarshaller;
import tigase.http.jaxrs.marshallers.Marshaller;
import tigase.http.jaxrs.marshallers.Unmarshaller;
import tigase.http.jaxrs.marshallers.WWWFormUrlEncodedUnmarshaller;
import tigase.http.jaxrs.marshallers.XmlMarshaller;
import tigase.http.jaxrs.marshallers.XmlUnmarshaller;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class JaxRsRequestHandler
implements RequestHandler {
    private static final Logger log = Logger.getLogger(JaxRsRequestHandler.class.getCanonicalName());
    private static final Map<Class, Function<String, Object>> DESERIALIZERS = new HashMap<Class, Function<String, Object>>();
    private final Handler.Role requiredRole;
    private final Handler handler;
    private final Method method;
    private final Pattern pattern;
    private final HttpMethod httpMethod;
    private final Set<String> consumedContentTypes;
    private final Set<String> producedContentTypes;

    static {
        DESERIALIZERS.put(Long.class, Long::parseLong);
        DESERIALIZERS.put(Integer.class, Integer::parseInt);
        DESERIALIZERS.put(Double.class, Double::parseDouble);
        DESERIALIZERS.put(Float.class, Float::parseFloat);
        DESERIALIZERS.put(String.class, s -> s);
        DESERIALIZERS.put(BareJID.class, BareJID::bareJIDInstanceNS);
        DESERIALIZERS.put(JID.class, JID::jidInstanceNS);
    }

    public static List<JaxRsRequestHandler> create(Handler instance) {
        Method[] methods;
        Path path = instance.getClass().getAnnotation(Path.class);
        ArrayList<JaxRsRequestHandler> handlers = new ArrayList<JaxRsRequestHandler>();
        Method[] methodArray = methods = instance.getClass().getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method;
            JaxRsRequestHandler handler = JaxRsRequestHandler.create(path == null ? "" : path.value(), instance, method = methodArray[n2]);
            if (handler != null) {
                handlers.add(handler);
            }
            ++n2;
        }
        return handlers;
    }

    public static JaxRsRequestHandler create(String contextPath, Handler instance, Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        HttpMethod httpMethod = JaxRsRequestHandler.getHttpMethod(method);
        if (httpMethod == null) {
            return null;
        }
        String methodPath = Optional.ofNullable(method.getAnnotation(Path.class)).map(Path::value).orElse("");
        String fullPath = contextPath;
        if (!methodPath.isEmpty() && !methodPath.startsWith("/")) {
            fullPath = String.valueOf(fullPath) + "/";
        }
        fullPath = String.valueOf(fullPath) + methodPath;
        Pattern pattern = JaxRsRequestHandler.prepareMatcher(fullPath, method);
        return new JaxRsRequestHandler(instance, method, httpMethod, pattern, instance.getRequiredRole());
    }

    public static HttpMethod getHttpMethod(Method method) {
        if (method.getAnnotation(GET.class) != null) {
            return HttpMethod.GET;
        }
        if (method.getAnnotation(POST.class) != null) {
            return HttpMethod.POST;
        }
        if (method.getAnnotation(PUT.class) != null) {
            return HttpMethod.PUT;
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return HttpMethod.DELETE;
        }
        return null;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    public Method getMethod() {
        return this.method;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public Handler.Role getRequiredRole() {
        return this.requiredRole;
    }

    public static Pattern prepareMatcher(String path, Method method) {
        Map<String, Class> paramClasses = JaxRsRequestHandler.methodsPathParams(method);
        int idx = -1;
        ArrayList<Param> params = new ArrayList<Param>();
        while ((idx = path.indexOf(123, idx + 1)) > -1) {
            int startIdx = idx;
            int endIdx = idx;
            while ((endIdx = path.indexOf(125, endIdx)) > -1 && path.charAt(endIdx) == '\\') {
            }
            if (endIdx == -1) {
                return null;
            }
            String paramName = path.substring(idx + 1, endIdx).trim();
            String paramRegex = JaxRsRequestHandler.regexForClass(paramClasses.get(paramName));
            if (paramRegex == null) {
                return null;
            }
            params.add(new Param(paramName, paramRegex, startIdx, endIdx + 1));
        }
        String regex = path;
        int i = params.size() - 1;
        while (i >= 0) {
            Param param = (Param)params.get(i);
            String prefix = regex.substring(0, param.startIdx);
            String suffix = regex.substring(param.endIdx);
            regex = String.valueOf(prefix) + "(?<" + param.name + ">" + param.regex + ")" + suffix;
            --i;
        }
        return Pattern.compile(regex);
    }

    private static String regexForClass(Class clazz) {
        if (Long.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
            return "[0-9]+";
        }
        if (String.class.isAssignableFrom(clazz)) {
            return "[^\\/]+";
        }
        if (BareJID.class.isAssignableFrom(clazz)) {
            return "[^\\/]+";
        }
        try {
            Method m = clazz.getDeclaredMethod("fromString", String.class);
            if (Modifier.isStatic(m.getModifiers())) {
                return "[^\\/]+";
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Method m = clazz.getDeclaredMethod("valueOf", String.class);
                if (Modifier.isStatic(m.getModifiers())) {
                    return "[^\\/]+";
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.log(Level.FINEST, "Method 'fromString' or 'valueOf' for conversation to object from String not found", e);
            }
            throw new RuntimeException(e);
        }
        return null;
    }

    private static Map<String, Class> methodsPathParams(Method method) {
        HashMap<String, Class> params = new HashMap<String, Class>();
        Parameter[] parameterArray = method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            PathParam pathParam = parameter.getAnnotation(PathParam.class);
            if (pathParam != null) {
                params.put(pathParam.value(), parameter.getType());
            }
            ++n2;
        }
        return params;
    }

    public JaxRsRequestHandler(Handler handler, Method method, HttpMethod httpMethod, Pattern pattern, Handler.Role requiredRole) {
        this.requiredRole = requiredRole;
        this.httpMethod = httpMethod;
        this.handler = handler;
        this.method = method;
        this.pattern = pattern;
        Consumes consumes = method.getAnnotation(Consumes.class);
        this.consumedContentTypes = consumes != null ? Arrays.stream(consumes.value()).collect(Collectors.toSet()) : Collections.emptySet();
        Produces produces = method.getAnnotation(Produces.class);
        this.producedContentTypes = produces != null ? Arrays.stream(produces.value()).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public Matcher test(HttpServletRequest request, String requestUri) {
        if (this.consumedContentTypes.contains(request.getContentType()) || this.consumedContentTypes.isEmpty()) {
            String header = request.getHeader("Accept");
            if (header != null && !this.producedContentTypes.isEmpty() && Arrays.stream(header.split(",")).map(AcceptedType::new).filter(it -> this.producedContentTypes.contains(it.getMimeType())).sorted(Comparator.comparing(AcceptedType::getPreference).reversed()).findFirst().map(AcceptedType::getMimeType).isEmpty()) {
                return null;
            }
            return this.pattern.matcher(requestUri);
        }
        return null;
    }

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, Matcher matcher, ScheduledExecutorService executorService) throws HttpException, IOException {
        ContainerRequestContext context = new ContainerRequestContext(request);
        Optional<String> acceptedType = this.selectResponseMimeType(this.method, request);
        ArrayList<Object> values = new ArrayList<Object>();
        AsyncResponseImpl asyncResponse = null;
        try {
            Parameter[] parameterArray = this.method.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter param = parameterArray[n2];
                Object value = null;
                PathParam pathParam = param.getAnnotation(PathParam.class);
                HeaderParam headerParam = param.getAnnotation(HeaderParam.class);
                FormParam formParam = param.getAnnotation(FormParam.class);
                QueryParam queryParam = param.getAnnotation(QueryParam.class);
                if (pathParam != null) {
                    valueStr = matcher.group(pathParam.value());
                    if (valueStr == null) {
                        valueStr = this.getParamDefaultValue(param);
                    }
                    if (valueStr != null) {
                        value = JaxRsRequestHandler.convertToValue(param.getType(), valueStr);
                    }
                } else if (headerParam != null) {
                    valueStr = request.getHeader(headerParam.value());
                    if (valueStr == null) {
                        valueStr = this.getParamDefaultValue(param);
                    }
                    if (valueStr != null) {
                        value = JaxRsRequestHandler.convertToValue(param.getType(), valueStr);
                    }
                } else if (formParam != null) {
                    valuesStr = request.getParameterValues(formParam.value());
                    if (valuesStr == null) {
                        valuesStr = new String[]{this.getParamDefaultValue(param)};
                    }
                    if (Boolean.TYPE.equals(param.getType())) {
                        value = valuesStr != null && valuesStr.length == 1 && "on".equals(valuesStr[0]);
                    } else if (valuesStr != null) {
                        value = JaxRsRequestHandler.convertToValue(param.getParameterizedType(), valuesStr);
                    }
                } else if (queryParam != null) {
                    valuesStr = request.getParameterValues(queryParam.value());
                    if (valuesStr == null) {
                        valuesStr = new String[]{this.getParamDefaultValue(param)};
                    }
                    if (Boolean.TYPE.equals(param.getType())) {
                        value = valuesStr != null && valuesStr.length == 1 && "on".equals(valuesStr[0]);
                    } else if (valuesStr != null) {
                        value = JaxRsRequestHandler.convertToValue(param.getParameterizedType(), valuesStr);
                    }
                } else if (param.getAnnotation(Suspended.class) != null) {
                    if (asyncResponse == null) {
                        asyncResponse = new AsyncResponseImpl(this, executorService, request, acceptedType);
                    }
                    value = asyncResponse;
                } else if (param.getAnnotation(BeanParam.class) != null) {
                    try {
                        value = new WWWFormUrlEncodedUnmarshaller().unmarshal(param.getType(), request);
                    }
                    catch (UnmarshalException ex) {
                        throw new HttpException(ex, 406);
                    }
                } else if (Pageable.class.isAssignableFrom(param.getType())) {
                    value = Pageable.from(request);
                } else if (SecurityContext.class.isAssignableFrom(param.getType())) {
                    value = context.getSecurityContext();
                } else if (HttpServletRequest.class.isAssignableFrom(param.getType())) {
                    value = context.getRequest();
                } else if (HttpServletResponse.class.isAssignableFrom(param.getType())) {
                    value = response;
                } else if (UriInfo.class.isAssignableFrom(param.getType())) {
                    value = context.getUriInfo();
                } else if (Model.class.isAssignableFrom(param.getType())) {
                    value = new Model(context);
                } else {
                    String contentType = request.getContentType();
                    if (contentType != null && (value = this.decodeContent(param.getType(), request)) != null) {
                        this.validateContent(value);
                    }
                }
                this.validateContent(param, value);
                values.add(value);
                ++n2;
            }
            try {
                ContainerRequestContext.setContext(context);
                Object result = this.method.invoke((Object)this.handler, values.toArray());
                if (Void.TYPE.equals(this.method.getReturnType())) {
                    return;
                }
                try {
                    if (result != null) {
                        this.sendEncodedContent(result, acceptedType, response);
                    } else {
                        response.setStatus(200);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    if (ex.getCause() instanceof HttpException) {
                        throw (HttpException)ex.getCause();
                    }
                    throw new HttpException(ex, 500);
                }
            }
            finally {
                ContainerRequestContext.resetContext();
            }
        }
        catch (Throwable ex) {
            if (asyncResponse != null) {
                asyncResponse.resume(ex);
            }
            log.log(Level.WARNING, "Exception while processing request", ex);
            throw ex;
        }
    }

    private void validateContent(AnnotatedElement store, Object value) {
        boolean notNull = store.isAnnotationPresent(NotNull.class);
        if (notNull && value == null) {
            this.throwValidationError(store, notNull, ValidationError.notNull);
        }
        if (notEmpty = store.isAnnotationPresent(NotEmpty.class)) {
            if (value instanceof String) {
                if (((String)value).isEmpty()) {
                    this.throwValidationError(store, notNull, ValidationError.notNull);
                }
            } else if (value instanceof Collection && ((Collection)value).isEmpty()) {
                this.throwValidationError(store, notNull, ValidationError.notNull);
            }
        }
        if ((notBlank = store.isAnnotationPresent(NotBlank.class)) && value instanceof String var6_7 && str.isBlank()) {
            this.throwValidationError(store, value, ValidationError.notBlank);
        }
    }

    private void throwValidationError(AnnotatedElement store, Object value, ValidationError error) {
        StringBuilder sb = new StringBuilder();
        if (store instanceof Field var5_6) {
            sb.append("Field ").append(field.getName()).append(" in object ").append(field.getDeclaringClass());
        } else {
            if (store instanceof Parameter var7_8) {
                sb.append("Parameter ").append(parameter.getName());
            } else {
                sb.append("Validation failed for ").append(store).append(" = ").append(value);
            }
        }
        StringBuilder stringBuilder = sb.append(" cannot be ");
        switch (error) {
            case notNull: {
                v1 = "NULL";
                break;
            }
            case notBlank: {
                v1 = "BLANK";
                break;
            }
            case notEmpty: {
                v1 = "EMPTY";
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        stringBuilder.append(v1).append("!");
        throw new ValidationException(sb.toString());
    }

    private void validateContent(Object object) throws HttpException {
        try {
            Field[] fieldArray = object.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                field.setAccessible(true);
                this.validateContent(field, field.get(object));
                ++n2;
            }
        }
        catch (IllegalAccessException ex) {
            throw new HttpException(ex, 500);
        }
    }

    private String getParamDefaultValue(Parameter param) {
        DefaultValue defValue = param.getAnnotation(DefaultValue.class);
        if (defValue == null) {
            return null;
        }
        return defValue.value();
    }

    public static Object convertToValue(Type expectedType, String[] valueStrs) {
        if (expectedType instanceof ParameterizedType) {
            Type[] params = ((ParameterizedType)expectedType).getActualTypeArguments();
            if (params == null || params.length != 1 || !(params[0] instanceof Class)) {
                return null;
            }
            return JaxRsRequestHandler.convertToValue((Class)((ParameterizedType)expectedType).getRawType(), (Class)params[0], valueStrs);
        }
        return JaxRsRequestHandler.convertToValue((Class)expectedType, null, valueStrs);
    }

    public static Object convertToValue(Class<?> expectedClass, Class<?> parameterClass, String[] valueStrs) {
        if (Collection.class.isAssignableFrom(expectedClass)) {
            if (parameterClass == null) {
                return null;
            }
            Stream<Object> stream = Arrays.stream(valueStrs).map(str -> JaxRsRequestHandler.convertToValue(parameterClass, str));
            if (List.class.isAssignableFrom(expectedClass)) {
                return stream.collect(Collectors.toUnmodifiableList());
            }
            if (Set.class.isAssignableFrom(expectedClass)) {
                return stream.collect(Collectors.toUnmodifiableSet());
            }
            if (SortedSet.class.isAssignableFrom(expectedClass)) {
                return Collections.unmodifiableSortedSet(new TreeSet(stream.collect(Collectors.toList())));
            }
            return null;
        }
        if (valueStrs.length != 1) {
            return null;
        }
        return JaxRsRequestHandler.convertToValue(expectedClass, valueStrs[0]);
    }

    private static Object convertToValue(Class expectedClass, String valueStr) {
        Function<String, Object> mapper = DESERIALIZERS.get(expectedClass);
        if (mapper == null) {
            try {
                Method method = expectedClass.getDeclaredMethod("fromString", String.class);
                return method.invoke(null, valueStr);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                try {
                    Method method = expectedClass.getDeclaredMethod("valueOf", String.class);
                    return method.invoke(null, valueStr);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException2) {
                    return null;
                }
            }
        }
        return mapper.apply(valueStr);
    }

    private Object decodeContent(Class clazz, HttpServletRequest request) throws HttpException, IOException {
        Unmarshaller unmarshaller = this.newUnmarshaller(request.getContentType());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ServletInputStream inputStream = request.getInputStream();){
                return unmarshaller.unmarshal(clazz, (InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnmarshalException e) {
            throw new HttpException(e, 422);
        }
    }

    public void sendEncodedContent(Object object, Optional<String> acceptedType, HttpServletResponse response) throws HttpException, IOException {
        try {
            if (object instanceof Response) {
                Response resp = (Response)object;
                for (Map.Entry entry : resp.getStringHeaders().entrySet()) {
                    for (String it : (List)entry.getValue()) {
                        response.addHeader((String)entry.getKey(), it);
                    }
                }
                Object entity = resp.getEntity();
                if (entity != null && entity instanceof byte[]) {
                    response.setContentLength(((byte[])entity).length);
                }
                Response.StatusType status = resp.getStatusInfo();
                response.setStatus(status.getStatusCode());
                if (entity != null) {
                    if (entity instanceof byte[]) {
                        response.getOutputStream().write((byte[])entity);
                    } else if (entity instanceof String) {
                        response.getWriter().write((String)entity);
                    } else {
                        this.encodeObject(object, acceptedType.orElse("application/xml"), response);
                    }
                } else if (status.getReasonPhrase() != null) {
                    response.getWriter().write(status.getReasonPhrase());
                }
            } else {
                this.encodeObject(object, acceptedType.orElse("application/xml"), response);
            }
        }
        catch (MarshalException e) {
            throw new HttpException(e, 500);
        }
    }

    private void encodeObject(Object object, String mimeType, HttpServletResponse response) throws UnsupportedFormatException, MarshalException, IOException {
        Marshaller marshaller = this.newMarshaller(mimeType);
        response.setContentType(mimeType);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ServletOutputStream outputStream = response.getOutputStream();){
            marshaller.marshall(object, (OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Marshaller newMarshaller(String acceptedType) throws UnsupportedFormatException {
        return switch (acceptedType) {
            case "application/json" -> new JsonMarshaller();
            case "application/xml" -> new XmlMarshaller();
            default -> throw new UnsupportedFormatException("Format '" + acceptedType + "' is not supported!");
        };
    }

    protected Optional<String> selectResponseMimeType(Method method, HttpServletRequest request) throws HttpException {
        if (this.producedContentTypes.isEmpty()) {
            return Optional.empty();
        }
        String header = request.getHeader("Accept");
        if (header == null) {
            return Optional.empty();
        }
        return Arrays.stream(header.split(",")).map(AcceptedType::new).filter(it -> this.producedContentTypes.contains(it.getMimeType())).sorted(Comparator.comparing(AcceptedType::getPreference).reversed()).findFirst().map(AcceptedType::getMimeType);
    }

    private Unmarshaller newUnmarshaller(String contentType) throws UnsupportedFormatException {
        return switch (contentType) {
            case "application/json" -> new JsonUnmarshaller();
            case "application/xml" -> new XmlUnmarshaller();
            default -> throw new UnsupportedFormatException("Format '" + contentType + "' is not supported!");
        };
    }

    @Override
    public int compareTo(RequestHandler rh) {
        if (rh instanceof JaxRsRequestHandler) {
            JaxRsRequestHandler o = (JaxRsRequestHandler)rh;
            int r = PATTERN_COMPARATOR.compare(this.pattern, o.pattern);
            if (r != 0) {
                return r;
            }
            r = o.consumedContentTypes.size() - this.consumedContentTypes.size();
            if (r != 0) {
                return r;
            }
            r = o.producedContentTypes.size() - this.producedContentTypes.size();
            return r;
        }
        return Integer.MAX_VALUE;
    }

    private static class Param {
        private final String name;
        private final String regex;
        private final int startIdx;
        private final int endIdx;

        private Param(String name, String regex, int startIdx, int endIdx) {
            this.name = name;
            this.regex = regex;
            this.startIdx = startIdx;
            this.endIdx = endIdx;
        }
    }

    static enum ValidationError {
        notNull,
        notEmpty,
        notBlank;

    }
}

