/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.TimeoutHandler;
import jakarta.xml.bind.ValidationException;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.http.api.HttpException;
import tigase.http.jaxrs.JaxRsRequestHandler;

public class AsyncResponseImpl
implements AsyncResponse {
    private static final Logger log = Logger.getLogger(AsyncResponseImpl.class.getCanonicalName());
    private final Optional<String> acceptedType;
    private final ScheduledExecutorService executorService;
    private final JaxRsRequestHandler requestHandler;
    private Future timeoutFuture;
    private TimeoutHandler timeoutHandler;
    private final AsyncContext context;
    private State state = State.suspended;

    public AsyncResponseImpl(JaxRsRequestHandler requestHandler, ScheduledExecutorService executorService, HttpServletRequest request, Optional<String> acceptedType) {
        this.requestHandler = requestHandler;
        this.executorService = executorService;
        this.context = request.startAsync();
        this.acceptedType = acceptedType;
    }

    public boolean resume(Object o) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        try {
            this.requestHandler.sendEncodedContent(o, this.acceptedType, (HttpServletResponse)this.context.getResponse());
        }
        catch (Throwable ex) {
            this.sendError(ex);
        }
        this.context.complete();
        this.state = State.done;
        return true;
    }

    public boolean resume(Throwable ex) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        this.sendError(ex);
        this.context.complete();
        this.state = State.done;
        return true;
    }

    private void sendError(Throwable ex) {
        try {
            if (ex instanceof ValidationException) {
                ((HttpServletResponse)this.context.getResponse()).sendError(406, ex.getMessage());
            } else if (ex instanceof HttpException) {
                HttpException he = (HttpException)ex;
                ((HttpServletResponse)this.context.getResponse()).sendError(he.getCode(), he.getMessage());
            } else {
                ((HttpServletResponse)this.context.getResponse()).sendError(500, "Internal Server Error");
            }
        }
        catch (IOException ex1) {
            log.log(Level.FINEST, "Failed to send error message", ex1);
        }
    }

    public boolean cancel() {
        try {
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
            }
            ((HttpServletResponse)this.context.getResponse()).sendError(503, "Service unavailable");
        }
        catch (IOException ex) {
            log.log(Level.FINEST, "Failed to send error message", ex);
        }
        this.context.complete();
        this.state = State.cancelled;
        return true;
    }

    public boolean cancel(int i) {
        return this.cancel();
    }

    public boolean cancel(Date date) {
        return this.cancel();
    }

    public boolean isSuspended() {
        return this.state == State.suspended;
    }

    public boolean isCancelled() {
        return this.state == State.cancelled;
    }

    public boolean isDone() {
        return this.state == State.done;
    }

    public boolean setTimeout(long delay, TimeUnit timeUnit) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
        this.timeoutFuture = this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                if (AsyncResponseImpl.this.timeoutHandler != null) {
                    try {
                        AsyncResponseImpl.this.timeoutHandler.handleTimeout((AsyncResponse)AsyncResponseImpl.this);
                    }
                    catch (Throwable throwable) {
                        AsyncResponseImpl.this.cancel();
                    }
                }
            }
        }, delay, timeUnit);
        return true;
    }

    public void setTimeoutHandler(TimeoutHandler timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
    }

    public Collection<Class<?>> register(Class<?> aClass) {
        throw new UnsupportedOperationException("Feature not implemented!");
    }

    public Map<Class<?>, Collection<Class<?>>> register(Class<?> aClass, Class<?> ... classes) {
        throw new UnsupportedOperationException("Feature not implemented!");
    }

    public Collection<Class<?>> register(Object o) {
        throw new UnsupportedOperationException("Feature not implemented!");
    }

    public Map<Class<?>, Collection<Class<?>>> register(Object o, Object ... objects) {
        throw new UnsupportedOperationException("Feature not implemented!");
    }

    public static enum State {
        suspended,
        done,
        cancelled;

    }
}

