/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import tigase.http.AuthProvider;
import tigase.http.DeploymentInfo;
import tigase.http.ServletInfo;
import tigase.http.java.AsyncContextImpl;
import tigase.http.java.DummyServletRequest;
import tigase.http.java.DummyServletResponse;
import tigase.http.java.JavaStandaloneHttpServer;
import tigase.http.java.filters.DummyFilterChain;
import tigase.http.java.filters.DummyFilterConfig;
import tigase.http.java.filters.ProtocolRedirectFilter;

public class RequestHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger(RequestHandler.class.getCanonicalName());
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final ThreadLocal<Integer> requestId = new ThreadLocal();
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int val1 = o1.length() - o1.replace("/", "").length();
            int val2 = o2.length() - o2.replace("/", "").length();
            if (val2 != val1) {
                return val2 - val1;
            }
            return Integer.compare(o2.length(), o1.length());
        }
    };
    private final String contextPath;
    private final JavaStandaloneHttpServer server;
    private final AuthProvider authProvider;
    private final Map<String, HttpServlet> servlets = new ConcurrentHashMap<String, HttpServlet>();
    private final JavaStandaloneHttpServer.ExecutorWithTimeout.Timer timer;
    private final ProtocolRedirectFilter protocolRedirectFilter;
    private final Optional<Set<String>> vhosts;

    public static void setRequestId() {
        requestId.set(counter.incrementAndGet());
    }

    public static Integer getRequestId() {
        return requestId.get();
    }

    public RequestHandler(JavaStandaloneHttpServer server, DeploymentInfo info, JavaStandaloneHttpServer.ExecutorWithTimeout.Timer timer) throws ServletException {
        ServletInfo[] servletInfos;
        this.server = server;
        this.vhosts = Optional.ofNullable(info.getVHosts()).map(stringArray -> Arrays.asList(stringArray)).map(CopyOnWriteArraySet::new);
        this.protocolRedirectFilter = new ProtocolRedirectFilter();
        DummyFilterConfig filterConfig = new DummyFilterConfig(this.protocolRedirectFilter.getClass(), server);
        this.protocolRedirectFilter.init(filterConfig);
        this.timer = timer;
        this.contextPath = info.getContextPath();
        this.authProvider = info.getAuthProvider();
        ServletInfo[] servletInfoArray = servletInfos = info.getServlets();
        int n = servletInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ServletInfo servletInfo = servletInfoArray[n2];
            this.registerServlet(servletInfo);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange he) throws IOException {
        HttpExchange httpExchange;
        boolean exception;
        int reqId;
        DummyServletResponse resp;
        DummyServletRequest req;
        block36: {
            this.timer.requestProcessingStarted();
            req = null;
            resp = null;
            reqId = RequestHandler.getRequestId();
            exception = false;
            try {
                if (this.vhosts.isPresent() && !this.vhosts.get().contains(Optional.ofNullable(he.getRequestHeaders().getFirst("Host")).map(host -> host.split(":")[0]).orElse(null))) {
                    HttpExchange httpExchange2 = he;
                    synchronized (httpExchange2) {
                        String error = "Not found";
                        he.sendResponseHeaders(404, error.length());
                        he.getResponseBody().write(error.getBytes(StandardCharsets.UTF_8));
                        he.close();
                    }
                    this.timer.requestProcessingFinished();
                    return;
                }
                String path = he.getRequestURI().getPath();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "received request " + reqId + " method " + he.getRequestMethod() + " for " + he.getRequestURI().toString() + ", headers:" + he.getRequestHeaders().entrySet().stream().map(e -> "'" + (String)e.getKey() + "': '" + e.getValue() + "'").collect(Collectors.joining(",")));
                }
                ArrayList<String> keys = new ArrayList<String>(this.servlets.keySet());
                Collections.sort(keys, COMPARATOR);
                boolean handled = false;
                for (String key : keys) {
                    if (!path.startsWith(key)) continue;
                    HttpServlet servlet = this.servlets.get(key);
                    if (servlet == null) break;
                    String servletPath = key.substring(this.contextPath.length(), key.length());
                    if (servletPath.isEmpty()) {
                        servletPath = "/";
                    }
                    resp = new DummyServletResponse(he);
                    req = new DummyServletRequest(reqId, he, this.contextPath, servletPath, this.authProvider, this.timer.getScheduledExecutorService(), this.timer.requestTimeoutSupplier.get(), resp);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "request " + reqId + " will be processed by " + servlet.getClass() + " for " + key);
                    }
                    DummyFilterChain filterChain = new DummyFilterChain(servlet);
                    filterChain.addFilter(this.protocolRedirectFilter);
                    filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
                    handled = true;
                    break;
                }
                if (handled) break block36;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "not found handler for request " + reqId + " for " + he.getRequestURI().toString());
                }
                HttpExchange httpExchange3 = he;
                synchronized (httpExchange3) {
                    he.sendResponseHeaders(404, -1L);
                }
            }
            catch (IOException ex) {
                this.timer.requestProcessingFinished();
                AsyncContext async = req.getAsyncContext();
                if (async != null && async instanceof AsyncContextImpl) {
                    ((AsyncContextImpl)async).cancel();
                }
                throw new IOException(ex);
            }
            catch (Throwable ex) {
                exception = true;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Exception during processing HTTP request" + reqId + " for " + he.getRequestURI().toString(), ex);
                }
                try {
                    httpExchange = he;
                    synchronized (httpExchange) {
                        he.sendResponseHeaders(500, -1L);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (req != null && resp != null) {
            AsyncContext async = req.getAsyncContext();
            if (async == null || exception) {
                try {
                    resp.flushBuffer();
                }
                catch (IOException iOException) {}
                if (async instanceof AsyncContextImpl) {
                    ((AsyncContextImpl)async).cancel();
                }
                httpExchange = he;
                synchronized (httpExchange) {
                    he.close();
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "request " + reqId + " processing finished!");
                }
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "request " + reqId + " processing finished!");
            }
            HttpExchange httpExchange4 = he;
            synchronized (httpExchange4) {
                he.close();
            }
        }
        this.timer.requestProcessingFinished();
    }

    private void registerServlet(ServletInfo info) {
        try {
            HttpServlet servlet = info.getServletClass().newInstance();
            ServletCfg cfg = new ServletCfg(info.getInitParams());
            servlet.init((ServletConfig)cfg);
            for (String mapping : info.getMappings()) {
                if (mapping.endsWith("/")) {
                    mapping = mapping.substring(0, mapping.length() - 1);
                }
                if ("/".equals(this.contextPath) && mapping.startsWith("/")) {
                    mapping = mapping.substring(1);
                }
                this.servlets.put(String.valueOf(this.contextPath) + mapping.replace("/*", ""), servlet);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(RequestHandler.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    private class ServletCfg
    implements ServletConfig {
        private final Map<String, String> params = new HashMap<String, String>();

        public ServletCfg(Map<String, String> map) {
            this.params.putAll(map);
        }

        public String getServletName() {
            return null;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public String getInitParameter(String string) {
            return this.params.get(string);
        }

        public Enumeration<String> getInitParameterNames() {
            return null;
        }
    }
}

